import React, {useState} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

import './Item.styl';

const b = cn('DeleteDataFAQItem');

export const DeleteDataFAQItem = ({question, answer, className}) => {
    const [opened, setOpened] = useState(false);

    return (
        <div className={b({opened}, [className])}>
            <div className={b('question')}>
                <button onClick={() => setOpened((v) => !v)}>{question}</button>
            </div>
            <div className={b('answer')} dangerouslySetInnerHTML={{__html: answer}} />
        </div>
    );
};

DeleteDataFAQItem.propTypes = {
    question: PropTypes.string.isRequired,
    answer: PropTypes.string.isRequired,
    className: PropTypes.string
};
