import React, {useState, useEffect, createContext} from 'react';
import PropTypes from 'prop-types';
import debounce from 'lodash/debounce';

export const Context = createContext(true);

const MIN_WIDTH = 600;

export const DeleteDataModalContext = ({children}) => {
    const [isModal, setIsModal] = useState(true);

    useEffect(() => {
        const update = () => setIsModal(window.innerWidth > MIN_WIDTH);
        const updateDebounced = debounce(update, 300);

        window.addEventListener('resize', updateDebounced);
        update();

        return () => window.removeEventListener('resize', updateDebounced);
    }, []);

    return <Context.Provider value={isModal}>{children}</Context.Provider>;
};

DeleteDataModalContext.propTypes = {
    children: PropTypes.node
};
