import React, {memo, useRef, useState} from 'react';
import {cn} from '@bem-react/classname';

import {Button} from '@components/Button';
import {DeleteDataButton} from '../Button';
import {DeleteDataDrawer} from '../Drawer';

import './Saved.styl';

const b = cn('DeleteDataSaved');

export const DeleteDataSaved = memo(() => {
    const scopeRef = useRef();
    const [isOpened, setOpened] = useState(false);

    return (
        <div className={b()} ref={scopeRef}>
            <DeleteDataButton icon='info' onClick={() => setOpened(true)}>
                {i18n('DeleteData.saved.label')}
            </DeleteDataButton>
            <DeleteDataDrawer
                scope={scopeRef}
                visible={isOpened}
                title={i18n('DeleteData.saved.title')}
                onClose={() => setOpened(false)}
            >
                <div className={b('desc')}>{i18n('DeleteData.saved.desc')}</div>
                <Button view='action' size='l' width='max' onClick={() => setOpened(false)}>
                    {i18n('DeleteData.ok.got-it')}
                </Button>
            </DeleteDataDrawer>
        </div>
    );
});

DeleteDataSaved.displayName = 'DeleteDataSaved';
