import React, {memo, useRef, useState} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {DeleteDataButton} from '../Button';
import {Button} from '@components/Button';
import {DeleteDataDrawer} from '../Drawer';
import {DeleteDataServiceLogo} from '../ServiceLogo';
import {externalServices} from '../info';

import './Sep.styl';

const b = cn('DeleteDataSep');

const BUTTONS = ['mail', 'cloud', 'calendar'];

export const DeleteDataSep = memo(({sepOpenBtnText = '', sepOpenBtnIcon = ''} = {}) => {
    const scopeRef = useRef();
    const [isOpened, setOpened] = useState(false);

    return (
        <div className={b()} ref={scopeRef}>
            <DeleteDataButton icon={sepOpenBtnIcon} onClick={() => setOpened(true)}>
                {sepOpenBtnText}
            </DeleteDataButton>
            <DeleteDataDrawer
                scope={scopeRef}
                visible={isOpened}
                title={i18n('DeleteData.sep.title')}
                onClose={() => setOpened(false)}
            >
                <div className={b('desc')}>{i18n('DeleteData.sep.desc')}:</div>
                <div className={b('links')}>
                    {BUTTONS.map((name) => (
                        <a
                            key={name}
                            target='_blank'
                            rel='noopener noreferrer'
                            className={b('link')}
                            href={externalServices[name].takeoutLink}
                        >
                            <DeleteDataServiceLogo id={name} className={b('linkLogo')} />
                            <div className={b('linkLabel')}>{externalServices[name].name}</div>
                        </a>
                    ))}
                </div>
                <Button view='action' size='l' width='max' onClick={() => setOpened(false)}>
                    {i18n('DeleteData.ok.got-it')}
                </Button>
            </DeleteDataDrawer>
        </div>
    );
});

DeleteDataSep.displayName = 'DeleteDataSep';

DeleteDataSep.propTypes = {
    sepOpenBtnText: PropTypes.string,
    sepOpenBtnIcon: PropTypes.string
};
