import React, {memo} from 'react';
import PropTypes from 'prop-types';
import {useSelector, shallowEqual} from 'react-redux';
import {processServiceItems} from '../util';
import {DeleteDataCard} from '../Card';

export const DeleteDataEmptyService = memo(({serviceName}) => {
    const {data} = useSelector(
        ({deleteData: {data}}) => ({
            data: data[serviceName]
        }),
        shallowEqual
    );
    const processedData = processServiceItems(serviceName, data);

    return processedData && <DeleteDataCard noData={true} serviceName={serviceName} title={processedData.name} />;
});

DeleteDataEmptyService.displayName = 'DeleteDataEmptyService';

DeleteDataEmptyService.propTypes = {
    serviceName: PropTypes.string.isRequired
};
