import React, {memo} from 'react';
import {useSelector, shallowEqual} from 'react-redux';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {DELETION_STATE} from '../../constants';
import {Spin} from '@components/Spin';
import {DeleteDataServiceTrachCan} from '../../TrashCan';

import './Item.styl';

const b = cn('DeleteDataServiceItem');

export const DeleteDataServiceItem = memo(
    ({id, state, title, deleteLink, updateDate, serviceName, description, onDelete}) => {
        const {loading} = useSelector(
            ({deleteData: {loadingServiceItems}}) => ({
                loading: (loadingServiceItems[serviceName] || {})[id]
            }),
            shallowEqual
        );
        const tld = useSelector(({settings} = {}) => settings.tld);
        const isReady = state === DELETION_STATE.ready;
        const isEmpty = state === DELETION_STATE.empty;
        const isInProgress = state === DELETION_STATE.inProgress;
        const Component = !isReady ? 'div' : deleteLink ? 'a' : 'button';

        return (
            <Component
                disabled={loading}
                className={b({inactive: loading || isEmpty || isInProgress, hoverable: !loading && isReady})}
                onClick={isReady && onDelete ? () => onDelete(id) : undefined}
                {...(Component === 'a'
                    ? {
                          href: deleteLink.replace('%tld', tld),
                          target: '_blank',
                          rel: 'noopener noreferrer'
                      }
                    : {})}
            >
                <div className={b('action')}>
                    {!loading && (
                        <>
                            {isReady && <DeleteDataServiceTrachCan />}
                            {isInProgress && <div className={b('clock')} />}
                        </>
                    )}
                    <Spin progress={loading} size='xxs' />
                </div>
                <div className={b('content')}>
                    <div className={b('title')}>{title}</div>
                    <div className={b('desc')}>
                        {isReady && description}
                        {isInProgress && i18n('DeleteData.service.deleting')}
                        {isEmpty &&
                            (updateDate
                                ? `${i18n('DeleteData.service.delete-date')}: ${updateDate}`
                                : i18n('DeleteData.delete.nothing'))}
                    </div>
                </div>
            </Component>
        );
    }
);

DeleteDataServiceItem.displayName = 'DeleteDataServiceItem';

DeleteDataServiceItem.propTypes = {
    onDelete: PropTypes.func,
    deleteLink: PropTypes.string,
    updateDate: PropTypes.string,
    description: PropTypes.string,
    id: PropTypes.string.isRequired,
    title: PropTypes.string.isRequired,
    state: PropTypes.string.isRequired,
    serviceName: PropTypes.string.isRequired
};
