import React, {memo, useCallback} from 'react';
import PropTypes from 'prop-types';
import metrics from '@blocks/metrics';
import {DELETION_STATE, DELETE_DATA_GOAL_PREFIX} from '../constants';
import {externalServices} from '../info';
import {DeleteDataCard} from '../Card';
import {DeleteDataServiceItem} from './Item';

export const DeleteDataPredefinedService = memo(({inner, serviceName}) => {
    const {name, description, data, link} = externalServices[serviceName];
    const onDelete = useCallback(() => {
        metrics.send(['Переход по ссылке удаления', name]);
        metrics.goal(`${DELETE_DATA_GOAL_PREFIX}_delete_service_${serviceName}`);
    }, [name, serviceName]);

    return (
        <DeleteDataCard inner={inner} title={name} serviceName={serviceName} description={description}>
            <DeleteDataServiceItem
                id='external'
                deleteLink={link}
                title={data.title}
                onDelete={onDelete}
                serviceName={serviceName}
                state={DELETION_STATE.ready}
                description={data.description}
            />
        </DeleteDataCard>
    );
});

DeleteDataPredefinedService.displayName = 'DeleteDataPredefinedService';

DeleteDataPredefinedService.propTypes = {
    inner: PropTypes.bool,
    serviceName: PropTypes.string.isRequired
};
