import React, {memo} from 'react';
import PropTypes from 'prop-types';
import {groups} from '../info';
import {DeleteDataCard} from '../Card';
import {DeleteDataService} from './Service';
import {DeleteDataEmptyService} from './EmptyService';
import {DeleteDataPredefinedService} from './PredefinedService';

export const ServiceItem = memo(({isGroup, noData, serviceName, isPredefined}) => {
    if (isGroup) {
        return (
            <DeleteDataCard
                groupName={serviceName}
                noData={noData}
                title={groups[serviceName].name}
                description={groups[serviceName].description}
            >
                {groups[serviceName].items.map((groupItem) =>
                    !noData ? (
                        <DeleteDataService serviceName={groupItem} />
                    ) : (
                        <DeleteDataEmptyService serviceName={groupItem} />
                    )
                )}
            </DeleteDataCard>
        );
    }

    if (noData) {
        return <DeleteDataEmptyService serviceName={serviceName} />;
    }

    return isPredefined ? (
        <DeleteDataPredefinedService serviceName={serviceName} />
    ) : (
        <DeleteDataService serviceName={serviceName} />
    );
});

ServiceItem.propTypes = {
    isGroup: PropTypes.bool,
    noData: PropTypes.bool.isRequired,
    serviceName: PropTypes.string.isRequired,
    isPredefined: PropTypes.bool
};
