import React, {memo, useCallback} from 'react';
import {useSelector} from 'react-redux';
import {cn} from '@bem-react/classname';
import {Button} from '@components/Button';
import {DeleteDataDrawer} from '../Drawer';

import './Session.styl';

const b = cn('DeleteDataSession');

export const DeleteDataSession = memo(() => {
    const {isVisible, hasPhone} = useSelector(({header: {defaultAccount}, deleteData: {isReloadDrawerVisible}}) => ({
        isVisible: isReloadDrawerVisible,
        hasPhone: defaultAccount.hasPhone
    }));
    const doReload = useCallback(() => window.location.reload(), []);

    return (
        <DeleteDataDrawer visible={isVisible}>
            <div className={b('desc')}>
                {hasPhone ? i18n('DeleteData.session.invalid') : i18n('DeleteData.session.invalid.no-phone')}
            </div>
            <div className={b('actions')}>
                <Button view='action' width='max' size='l' onClick={doReload} className={b('action')}>
                    {i18n('common.ok')}
                </Button>
            </div>
        </DeleteDataDrawer>
    );
});

DeleteDataSession.displayName = 'DeleteDataSession';
