import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Button} from '@components/Button';

import './Confirmation.styl';

const b = cn('DeleteDataTakeoutConfirmation');

export const DeleteDataTakeoutConfirmation = ({isLoading, onCancel, onConfirm}) => {
    return (
        <div className={b()}>
            <div className={b('desc')}>{i18n('DeleteData.takeout.confirmation.desc')}</div>
            <div className={b('actions')}>
                <Button
                    progress={isLoading}
                    view='action'
                    size='l'
                    width='max'
                    className={b('action')}
                    onClick={onConfirm}
                >
                    {i18n('DeleteData.takeout.prepare')}
                </Button>
                <Button
                    disabled={isLoading}
                    view='default'
                    size='l'
                    width='max'
                    className={b('action')}
                    onClick={onCancel}
                >
                    {i18n('DeleteData.cancel')}
                </Button>
            </div>
        </div>
    );
};

DeleteDataTakeoutConfirmation.propTypes = {
    onConfirm: PropTypes.func.isRequired,
    onCancel: PropTypes.func.isRequired,
    isLoading: PropTypes.bool
};
