import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Button} from '@components/Button';
import {DeleteDataServiceLogo} from '../../ServiceLogo';

import './Included.styl';

const SERVICES = [
    {
        id: 'alisa',
        name: i18n('common.serviceTitles.alisa')
    },
    {
        id: 'afisha',
        name: i18n('common.serviceTitles.afisha')
    },
    {
        id: 'browser',
        name: i18n('TakeOut.getdata_browser')
    },
    {
        id: 'zen',
        name: i18n('common.serviceTitles.zen')
    },
    {
        id: 'drive',
        name: i18n('common.serviceTitles.drive')
    },
    {
        id: 'maps',
        name: i18n('common.serviceTitles.maps')
    },
    {
        id: 'kinopoisk',
        name: i18n('common.serviceTitles.kinopoisk')
    },
    {
        id: 'collections',
        name: i18n('common.serviceTitles.collections')
    },
    {
        id: 'market',
        name: i18n('common.serviceTitles.market')
    },
    {
        id: 'music',
        name: i18n('common.serviceTitles.music')
    },
    {
        id: 'navigator',
        name: i18n('TakeOut.getdata_tech_navigator')
    },
    {
        id: 'yandex',
        name: i18n('_AUTH_.yandex')
    },
    {
        id: 'taxi',
        name: i18n('common.serviceTitles.taxi ')
    },
    {
        id: 'toloka',
        name: i18n('common.serviceTitles.toloka')
    },
    {
        id: 'datasync',
        name: i18n('common.serviceTitles.datasync')
    }
];

const b = cn('DeleteDataTakeoutIncluded');

export const DeleteDataTakeoutIncluded = ({onConfirm}) => {
    return (
        <div className={b()}>
            <div className={b('services')}>
                {SERVICES.map(({id, name}) => (
                    <div key={id} className={b('service')}>
                        <DeleteDataServiceLogo id={id} className={b('serviceLogo')} />
                        <div className={b('serviceName')}>{name}</div>
                    </div>
                ))}
            </div>
            <div className={b('subtitle')}>{i18n('DeleteData.takeout.included.also')}:</div>
            <div className={b('list')}>{i18n('DeleteData.takeout.included.list')}</div>
            <Button view='action' size='l' width='max' onClick={onConfirm}>
                {i18n('DeleteData.ok.got-it')}
            </Button>
        </div>
    );
};

DeleteDataTakeoutIncluded.propTypes = {
    onConfirm: PropTypes.func
};
