import React, {useRef, useState, useEffect} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

import './Toaster.styl';

const b = cn('DeleteDataToaster');

export const DeleteDataToaster = ({icon, text}) => {
    const timerRef = useRef(null);
    const lastTextRef = useRef(text);
    const [isVisible, setVisibility] = useState(Boolean(text));

    useEffect(() => {
        if (text) {
            clearTimeout(timerRef.current);
            setVisibility(true);
            lastTextRef.current = text;
            timerRef.current = setTimeout(() => setVisibility(false), 4000);
        }
    }, [text]);

    return (
        <div className={b({active: isVisible})}>
            {icon && <div className={b('icon', {[icon]: true})} />}
            <span>{text || lastTextRef.current}</span>
        </div>
    );
};

DeleteDataToaster.propTypes = {
    icon: PropTypes.oneOf(['ok']),
    text: PropTypes.string
};
