import React, {memo, useState, useCallback} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Button} from '@components/Button';
import {DeleteDataDrawer} from '../Drawer';

import './Unbind.styl';

const b = cn('DeleteDataUnbind');

export const DeleteDataUnbind = memo(({className}) => {
    const [isDrawerVisible, setDrawerVisibility] = useState(false);
    const closeDrawer = useCallback(() => setDrawerVisibility(false), []);

    return (
        <div className={b('', [className])}>
            <button className={b('action')} onClick={() => setDrawerVisibility(true)}>
                <span>{i18n('DeleteData.unbind.label')}. </span>
                <span className={b('action_Wdtm')}>{i18n('DeleteData.wdtm')}</span>
            </button>
            <DeleteDataDrawer visible={isDrawerVisible} onClose={closeDrawer}>
                <Button view='action' width='max' size='l' onClick={closeDrawer}>
                    {i18n('DeleteData.ok.got-it')}
                </Button>
            </DeleteDataDrawer>
        </div>
    );
});

DeleteDataUnbind.displayName = 'DeleteDataUnbind';

DeleteDataUnbind.propTypes = {
    className: PropTypes.string
};
