import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {DeleteDataButton} from '../Button';

import './Warning.styl';

const b = cn('DeleteDataWarning');

export const DeleteDataWarning = ({onClick, decor = 'info', text = '', buttonText = '', children}) => (
    <div className={b()}>
        <div className={b('icon', {decor})} />
        <div className={b('content')}>
            {text && <div className={b('text')}>{text}</div>}
            {buttonText && onClick && (
                <DeleteDataButton fullWidth={true} onClick={onClick}>
                    {buttonText}
                </DeleteDataButton>
            )}
            {children}
        </div>
    </div>
);

DeleteDataWarning.displayName = 'DeleteDataWarning';

DeleteDataWarning.propTypes = {
    onClick: PropTypes.func,
    decor: PropTypes.string,
    text: PropTypes.string,
    buttonText: PropTypes.string,
    children: PropTypes.node
};
