import React, {memo, useRef, useState} from 'react';
import {cn} from '@bem-react/classname';
import {Button} from '@components/Button';
import {DeleteDataButton} from '../Button';
import {DeleteDataDrawer} from '../Drawer';
import {DeleteDataServiceLogo} from '../ServiceLogo';
import {SERVICES} from './data';

import './Which.styl';

const b = cn('DeleteDataWhich');

export const DeleteDataWhich = memo(() => {
    const scopeRef = useRef();
    const [isOpened, setOpened] = useState(false);
    const [othersVisible, setOthersVisibility] = useState(false);

    return (
        <div className={b()} ref={scopeRef}>
            <DeleteDataButton icon='folder' onClick={() => setOpened(true)}>
                {i18n('DeleteData.which.label')}
            </DeleteDataButton>
            <DeleteDataDrawer
                scope={scopeRef}
                visible={isOpened}
                title={i18n('DeleteData.which.title')}
                onClose={() => setOpened(false)}
            >
                <div className={b('services')}>
                    {SERVICES.map(({id, name}) => (
                        <div key={id} className={b('service')}>
                            <DeleteDataServiceLogo id={id} className={b('serviceLogo')} />
                            <div className={b('serviceName')}>{name}</div>
                        </div>
                    ))}
                </div>
                <div className={b('others', {collapsed: !othersVisible})}>
                    {othersVisible ? (
                        i18n('DeleteData.which.services')
                    ) : (
                        <DeleteDataButton iconRight='arrowDown' onClick={() => setOthersVisibility(true)}>
                            {i18n('DeleteData.services.other')}
                        </DeleteDataButton>
                    )}
                </div>
                <Button view='action' size='l' width='max' onClick={() => setOpened(false)}>
                    {i18n('DeleteData.ok.got-it')}
                </Button>
            </DeleteDataDrawer>
        </div>
    );
});

DeleteDataWhich.displayName = 'DeleteDataWhich';
