import {
    DELETE_DATA_SET_DATA,
    DELETE_DATA_SET_ERROR,
    DELETE_DATA_MERGE_DATA,
    DELETE_DATA_SET_READINESS,
    DELETE_DATA_SHOW_RELOAD_DRAWER,
    DELETE_DATA_MERGE_SERVICE_DATA,
    DELETE_DATA_SET_SERVICE_ITEM_ERROR,
    DELETE_DATA_SET_SERVICE_ITEMS_ERROR,
    DELETE_DATA_CLEAR_SERVICE_ITEMS_ERROR,
    DELETE_DATA_SET_SERVICE_ITEM_LOADING,
    DELETE_DATA_SET_SERVICE_ITEMS_LOADING,
    DELETE_DATA_SET_SERVICES_IN_PROGRESS,
    DELETE_DATA_SHOW_CUSTOM_ERROR_POPUP,
    DELETE_DATA_HIDE_CUSTOM_ERROR_POPUP
} from './constants';

export const showReloadDrawer = () => ({type: DELETE_DATA_SHOW_RELOAD_DRAWER});
export const showCustomErrorPopup = (payload) => ({type: DELETE_DATA_SHOW_CUSTOM_ERROR_POPUP, payload});
export const hideCustomErrorPopup = (payload) => ({type: DELETE_DATA_HIDE_CUSTOM_ERROR_POPUP, payload});

export const setData = (data) => ({
    data,
    type: DELETE_DATA_SET_DATA
});

export const setError = (error) => ({
    error,
    type: DELETE_DATA_SET_ERROR
});

export const mergeData = (data) => ({
    data,
    type: DELETE_DATA_MERGE_DATA
});

export const setServicesInProgress = (servicesInProgress) => ({
    servicesInProgress,
    type: DELETE_DATA_SET_SERVICES_IN_PROGRESS
});

export const mergeServiceData = (data) => ({
    data,
    type: DELETE_DATA_MERGE_SERVICE_DATA
});

export const setServiceItemLoading = (service, id, loading) => ({
    id,
    loading,
    service,
    type: DELETE_DATA_SET_SERVICE_ITEM_LOADING
});

export const setServiceItemsLoading = (service, ids, loading) => ({
    ids,
    service,
    loading,
    type: DELETE_DATA_SET_SERVICE_ITEMS_LOADING
});

export const setServiceItemError = (service, id, error) => ({
    id,
    error,
    service,
    type: DELETE_DATA_SET_SERVICE_ITEM_ERROR
});

export const setServiceItemsError = (service, ids, error) => ({
    ids,
    error,
    service,
    type: DELETE_DATA_SET_SERVICE_ITEMS_ERROR
});

export const clearServiceItemsError = (service) => ({
    service,
    type: DELETE_DATA_CLEAR_SERVICE_ITEMS_ERROR
});

export const setReadiness = (ready) => ({
    ready,
    type: DELETE_DATA_SET_READINESS
});
