export const externalServices = {
    mail: {
        name: i18n('DeleteData.service.mail.title'),
        description: i18n('DeleteData.service.mail.description'),
        data: {title: i18n('DeleteData.service.mail.data.title')},
        link: 'https://passport.yandex.ru/passport?mode=unsubscribe&from=mail',
        takeoutLink: 'https://yandex.ru/support/mail/download-all-letters.html'
    },
    cloud: {
        name: i18n('DeleteData.service.cloud.title'),
        description: i18n('DeleteData.service.cloud.description'),
        data: {title: i18n('DeleteData.service.cloud.data.title')},
        link: 'https://yandex.ru/support/disk/actions-files/spec-folders/trash.html',
        takeoutLink: 'https://yandex.ru/support/disk/actions-files/download.html'
    },
    cloud_ext: {
        name: i18n('DeleteData.service.cloud_ext.name'),
        description: i18n('DeleteData.service.cloud_ext.description'),
        data: {title: i18n('DeleteData.service.cloud_ext.data.title')},
        link: 'https://cloud.yandex.ru/docs/overview/concepts/data-deletion#cloud',
        isBusinessService: true
    },
    station: {
        name: i18n('DeleteData.service.station.title'),
        description: i18n('DeleteData.service.station.description'),
        data: {title: i18n('DeleteData.service.station.data.title')},
        link: 'https://yandex.ru/support/station/settings/reset.html'
    },
    calendar: {
        name: i18n('common.serviceTitles.calendar'),
        link:
            // eslint-disable-next-line max-len
            'https://calendar.yandex-team.ru/event/56186702?applyToFuture=0&event_date=2021-05-18T13:30:00&layerId=66015',
        takeoutLink: 'https://yandex.ru/support/calendar/common/sync/export.html',
        isHiddenFromList: true
    }
};

export const services = {
    appmetrika: {
        name: i18n('DeleteData.service.appmetrika.name'),
        description: i18n('DeleteData.service.appmetrika.description'),
        fields: {
            1: {title: i18n('DeleteData.service.appmetrika.field.applications.title')},
            2: {title: i18n('DeleteData.service.appmetrika.field.media_sources.title')},
            3: {title: i18n('DeleteData.service.appmetrika.field.labels.title')}
        },
        isBusinessService: true
    },
    audience: {
        name: i18n('DeleteData.service.audience.name'),
        description: i18n('DeleteData.service.audience.description'),
        fields: {
            1: {title: i18n('DeleteData.service.audience.field.all.title')}
        },
        isBusinessService: true
    },
    blogs: {
        name: i18n('DeleteData.service.blogs.name'),
        description: i18n('DeleteData.service.blogs.description'),
        fields: {
            posts: {title: i18n('DeleteData.service.blogs.field.posts.title')},
            comments: {title: i18n('DeleteData.service.blogs.field.comments.title')},
            subscriptions: {title: i18n('DeleteData.service.blogs.field.subscriptions.title')}
        }
    },
    browser: {
        name: i18n('DeleteData.service.browser.name'),
        description: i18n('DeleteData.service.browser.description'),
        fields: {
            1: {title: i18n('DeleteData.service.browser.field.browser_sync_data.title')}
        }
    },
    carsharing: {
        name: i18n('DeleteData.service.carsharing.name'),
        description: i18n('DeleteData.service.carsharing.description'),
        fields: {
            drive_user_data: {title: i18n('DeleteData.service.carsharing.field.drive_user_data.title')}
        }
    },
    collections: {
        name: i18n('DeleteData.service.collections.name'),
        description: i18n('DeleteData.service.collections.description'),
        fields: {
            1: {title: i18n('DeleteData.service.collections.field.boards.title')}
        }
    },
    contest: {
        name: i18n('DeleteData.service.contest.name'),
        description: i18n('DeleteData.service.contest.description'),
        fields: {
            1: {title: i18n('DeleteData.service.contest.field.member.title')}
        }
    },
    crypta: {
        name: i18n('DeleteData.service.crypta.name'),
        description: i18n('DeleteData.service.crypta.description'),
        fields: {
            matching: {title: i18n('DeleteData.service.crypta.field.matching.title')}
        }
    },
    translate: {
        name: i18n('DeleteData.service.translate.title'),
        description: i18n('DeleteData.service.translate.description'),
        fields: {
            1: {title: i18n('DeleteData.service.translate.field.collections.title')}
        }
    },
    weather: {
        name: i18n('DeleteData.service.weather.title'),
        description: i18n('DeleteData.service.weather.description'),
        fields: {
            1: {title: i18n('DeleteData.service.weather.field.favorites.title')}
        }
    },
    edadeal: {
        name: i18n('common.serviceTitles.edadeal'),
        description: i18n('DeleteData.service.edadeal.description'),
        fields: {
            1: {title: i18n('DeleteData.service.edadeal.field.whole-account.title')}
        }
    },
    games: {
        name: i18n('DeleteData.service.games.name'),
        description: i18n('DeleteData.service.games.description'),
        fields: {
            1: {title: i18n('DeleteData.service.games.field.data.title')}
        }
    },
    forms: {
        name: i18n('DeleteData.service.forms.name'),
        description: i18n('DeleteData.service.forms.description'),
        fields: {
            1: {title: i18n('DeleteData.service.forms.field.answers.title')}
        }
    },
    market: {
        name: i18n('common.serviceTitles.market'),
        description: i18n('DeleteData.service.market.description'),
        fields: {
            cart: {title: i18n('DeleteData.service.market.field.cart.title')},
            orders: {title: i18n('DeleteData.service.market.field.orders.title')},
            history: {title: i18n('DeleteData.service.market.field.history.title')},
            support: {title: i18n('DeleteData.service.market.field.support.title')},
            comparisons: {title: i18n('DeleteData.service.market.field.comparisons.title')},
            publications: {title: i18n('DeleteData.service.market.field.publications.title')},
            subscriptions: {title: i18n('DeleteData.service.market.field.subscriptions.title')}
        }
    },
    mapsconstructor: {
        name: i18n('common.serviceTitles.mapsconstructor'),
        description: i18n('DeleteData.service.mapsconstructor.description'),
        fields: {
            1: {title: i18n('DeleteData.service.mapsconstructor.field.maps.title')}
        },
        group: 'geo'
    },
    portal: {
        name: i18n('DeleteData.service.portal.name'),
        description: i18n('DeleteData.service.portal.description'),
        fields: {
            0: {title: i18n('DeleteData.service.portal.field.widgets_settings.title')},
            1: {title: i18n('DeleteData.service.portal.field.settings.title')},
            2: {title: i18n('DeleteData.service.portal.field.addresses.title')},
            3: {title: i18n('DeleteData.service.portal.field.folded_blocks.title')},
            4: {title: i18n('DeleteData.service.portal.field.notifications.title')}
        }
    },
    praktikum: {
        name: i18n('DeleteData.service.praktikum.name'),
        description: i18n('DeleteData.service.praktikum.description'),
        fields: {
            1: {title: i18n('DeleteData.service.praktikum.field.users_data.title')}
        }
    },
    profi: {
        name: i18n('DeleteData.service.profi.name'),
        description: i18n('DeleteData.service.profi.description'),
        fields: {
            1: {title: i18n('DeleteData.service.profi.field.user_info.title')}
        }
    },
    kinopoisk: {
        name: i18n('DeleteData.service.kinopoisk.name'),
        description: i18n('DeleteData.service.kinopoisk.description'),
        fields: {
            COMMENTS_AND_VOTES: {title: i18n('DeleteData.service.kinopoisk.field.COMMENTS_AND_VOTES.title')},
            FOLDERS_AND_NOTES: {title: i18n('DeleteData.service.kinopoisk.field.FOLDERS_AND_NOTES.title')},
            VOTES_REACTIONS_VIEWS: {title: i18n('DeleteData.service.kinopoisk.field.VOTES_REACTIONS_VIEWS.title')},
            SEARCH_SUGGEST: {title: i18n('DeleteData.service.kinopoisk.field.SEARCH_SUGGEST.title')},
            OTT: {title: i18n('DeleteData.service.kinopoisk.field.OTT.title')},
            USER_PROFILE: {title: i18n('DeleteData.service.kinopoisk.field.USER_PROFILE.title')},
            USER_LOG: {title: i18n('DeleteData.service.kinopoisk.field.USER_LOG.title')},
            MESSAGES: {title: i18n('DeleteData.service.kinopoisk.field.MESSAGES.title')},
            SUBSCRIPTIONS: {title: i18n('DeleteData.service.kinopoisk.field.SUBSCRIPTIONS.title')},
            FILM_REVIEW_VOTES: {title: i18n('DeleteData.service.kinopoisk.field.FILM_REVIEW_VOTES.title')},
            USER_CINEMAS: {title: i18n('DeleteData.service.kinopoisk.field.USER_CINEMAS.title')}
        }
    },
    lavka: {
        name: i18n('DeleteData.service.lavka.name'),
        description: i18n('DeleteData.service.lavka.description'),
        fields: {
            all_grocery: {title: i18n('DeleteData.service.lavka.field.lavka_grocery.title')}
        }
    },
    metrika: {
        name: i18n('DeleteData.service.metrika.name'),
        description: i18n('DeleteData.service.metrika.description'),
        fields: {
            1: {title: i18n('DeleteData.service.metrika.field.all.title')}
        },
        isBusinessService: true
    },
    deli: {
        name: i18n('DeleteData.service.deli.name'),
        description: i18n('DeleteData.service.lavka.description'),
        fields: {
            all_grocery_deli: {title: i18n('DeleteData.service.deli.field.lavka_grocery.title')}
        }
    },
    ugc: {
        name: i18n('DeleteData.service.ugc.title'),
        description: i18n('DeleteData.service.ugc.description'),
        fields: {
            all: {title: i18n('DeleteData.service.ugc.field.ugc_all.title')}
        }
    },
    uslugi: {
        name: i18n('DeleteData.service.uslugi.title'),
        description: i18n('DeleteData.service.uslugi.description'),
        fields: {
            worker_data: {title: i18n('DeleteData.service.uslugi.field.worker_data.title')},
            customer_orders: {title: i18n('DeleteData.service.uslugi.field.customer_orders.title')}
        },
        isBusinessService: true
    },
    geosmb: {
        name: i18n('DeleteData.service.geosmb.title'),
        description: i18n('DeleteData.service.geosmb.description'),
        fields: {
            1: {title: i18n('DeleteData.service.geosmb.field.all.title')}
        }
    },
    sitesearch: {
        name: i18n('DeleteData.service.sitesearch.title'),
        description: i18n('DeleteData.service.sitesearch.description'),
        fields: {
            1: {title: i18n('DeleteData.service.sitesearch.field.general.title')}
        },
        isBusinessService: true
    },
    mapsugc: {
        name: i18n('DeleteData.service.mapsugc.title'),
        description: i18n('DeleteData.service.mapsugc.description'),
        fields: {
            ugc_id: {title: i18n('DeleteData.service.mapsugc.field.ugc_data.title')}
        },
        group: 'geo'
    },
    mapsroadevents: {
        name: i18n('common.serviceTitles.mapsroadevents'),
        description: i18n('DeleteData.service.mapsroadevents.description'),
        fields: {
            road_events: {title: i18n('DeleteData.service.mapsroadevents.field.road_events.title')}
        },
        group: 'geo'
    },
    mapspano: {
        name: i18n('common.serviceTitles.mapspano'),
        description: i18n('DeleteData.service.mapspano.description'),
        fields: {
            1: {title: i18n('DeleteData.service.mapspano.field.shipments.title')}
        },
        group: 'geo'
    },
    mapsmrc: {
        name: i18n('DeleteData.service.mapsmrc.title'),
        description: i18n('DeleteData.service.mapsmrc.description'),
        fields: {
            1: {title: i18n('DeleteData.service.mapsmrc.field.photos.title')}
        },
        group: 'geo'
    },
    zen: {
        name: i18n('common.serviceTitles.zen'),
        description: i18n('DeleteData.service.zen.description'),
        fields: {
            1: {title: i18n('DeleteData.service.zen.field.user_history.title')},
            2: {title: i18n('DeleteData.service.zen.field.social_data.title')},
            3: {title: i18n('DeleteData.service.zen.field.publisher_info.title')}
        }
    },
    nmaps: {
        name: i18n('common.serviceTitles.nmaps'),
        description: i18n('DeleteData.service.nmaps.description'),
        fields: {
            nmaps_id: {title: i18n('DeleteData.service.nmaps.field.nmaps_data.title')}
        },
        group: 'geo'
    },
    maps: {
        name: i18n('DeleteData.service.maps.title'),
        description: i18n('DeleteData.service.maps.description'),
        fields: {
            fbapi_id: {title: i18n('DeleteData.service.maps.field.fbapi_data.title')}
        },
        group: 'geo'
    },
    mapsphoto: {
        name: i18n('DeleteData.service.mapsphoto.title'),
        description: i18n('DeleteData.service.mapsphoto.description'),
        fields: {
            1: {title: i18n('DeleteData.service.mapsphoto.field.photos.title')}
        },
        group: 'geo'
    },
    messenger: {
        name: i18n('DeleteData.service.messenger.title'),
        description: i18n('DeleteData.service.messenger.description'),
        fields: {
            0: {title: i18n('DeleteData.service.messenger.field.all.title')}
        }
    },
    music: {
        name: i18n('common.serviceTitles.music'),
        description: i18n('DeleteData.service.music.description'),
        fields: {
            LIKES: {title: i18n('DeleteData.service.music.field.likes.title')},
            SETTINGS: {title: i18n('DeleteData.service.music.field.settings.title')},
            PLAYLISTS: {title: i18n('DeleteData.service.music.field.playlists.title')},
            RECOMMENDATIONS: {title: i18n('DeleteData.service.music.field.recommendations.title')},
            LISTENING_HISTORY: {title: i18n('DeleteData.service.music.field.listening_history.title')}
        }
        // unbind: true
    },
    alisa: {
        name: i18n('DeleteData.service.alisa.title'),
        description: i18n('DeleteData.service.alisa.description'),
        fields: {
            Logs: {title: i18n('DeleteData.service.alisa.field.Logs.title')},
            Memento: {title: i18n('DeleteData.service.alisa.field.Memento.title')},
            Datasync: {title: i18n('DeleteData.service.alisa.field.Datasync.title')},
            Notificator: {title: i18n('DeleteData.service.alisa.field.Notificator.title')},
            VinsContext: {title: i18n('DeleteData.service.alisa.field.VinsContext.title')},
            YabioContext: {title: i18n('DeleteData.service.alisa.field.YabioContext.title')},
            Contacts: {title: i18n('DeleteData.service.alisa.field.Contacts.title')}
        }
    },
    q: {
        name: i18n('DeleteData.service.q.title'),
        description: i18n('DeleteData.service.q.description'),
        fields: {
            0: {title: i18n('DeleteData.service.q.field.user.title')}
        }
    },
    realty: {
        name: i18n('DeleteData.service.realty.title'),
        description: i18n('DeleteData.service.realty.description'),
        fields: {
            1: {title: i18n('DeleteData.service.realty.field.favorites.title')},
            2: {title: i18n('DeleteData.service.realty.field.notes.title')},
            3: {title: i18n('DeleteData.service.realty.field.mortgage_demands.title')},
            4: {title: i18n('DeleteData.service.realty.field.offers.title')},
            5: {title: i18n('DeleteData.service.realty.field.hidden_clusters.title')},
            6: {title: i18n('DeleteData.service.realty.field.subscriptions.title')},
            7: {title: i18n('DeleteData.service.realty.field.offers_comparison.title')}
        }
    },
    schoolbook: {
        name: i18n('DeleteData.service.schoolbook.title'),
        description: i18n('DeleteData.service.schoolbook.description'),
        fields: {
            1: {title: i18n('DeleteData.service.schoolbook.field.user_data.title')},
            2: {title: i18n('DeleteData.service.schoolbook.field.teams.title')},
            3: {title: i18n('DeleteData.service.schoolbook.field.children.title')}
        }
    },
    surveys: {
        name: i18n('DeleteData.service.surveys.name'),
        description: i18n('DeleteData.service.surveys.description'),
        fields: {
            1: {title: i18n('DeleteData.service.surveys.field.surveys.title')},
            2: {title: i18n('DeleteData.service.surveys.field.settings.title')},
            3: {title: i18n('DeleteData.service.surveys.field.history.title')}
        }
    },
    tanker: {
        name: i18n('DeleteData.service.tanker.title'),
        description: i18n('DeleteData.service.tanker.description'),
        fields: {
            all: {title: i18n('DeleteData.service.tanker.field.all.title')}
        }
    },
    telemed: {
        name: i18n('DeleteData.service.telemed.title'),
        description: i18n('DeleteData.service.telemed.description'),
        fields: {
            1: {title: i18n('DeleteData.service.telemed.field.account.title')}
        }
    },
    overload: {
        name: i18n('DeleteData.service.overload.title'),
        description: i18n('DeleteData.service.overload.description'),
        fields: {
            user_data: {title: i18n('DeleteData.service.overload.field.user_data.title')}
        },
        isBusinessService: true
    },
    taxi: {
        name: i18n('common.serviceTitles.taxi '),
        description: i18n('DeleteData.service.taxi.description'),
        fields: {
            all_taxi: {title: i18n('DeleteData.service.taxi.field.common_taxi_data.title')},
            taxi_history: {title: i18n('DeleteData.service.taxi.field.taxi_history.title')}
        }
    },
    adfox: {
        name: i18n('DeleteData.service.adfox.title'),
        description: i18n('DeleteData.service.adfox.description'),
        fields: {
            1: {title: i18n('DeleteData.service.adfox.field.all_data.title')}
        },
        isBusinessService: true
    },
    eats: {
        name: i18n('DeleteData.service.eats.title'),
        description: i18n('DeleteData.service.eats.description'),
        fields: {
            eda_history: {title: i18n('DeleteData.service.eats.field.eda_history.title')}
        }
    },
    commentator: {
        name: i18n('DeleteData.service.commentator.title'),
        description: i18n('DeleteData.service.commentator.description'),
        fields: {
            1: {title: i18n('DeleteData.service.commentator.field.cmnt.title')}
        }
    },
    travelorchestrator: {
        name: i18n('DeleteData.service.travelorchestrator.title'),
        description: i18n('DeleteData.service.travelorchestrator.description'),
        fields: {
            orders: {title: i18n('DeleteData.service.travelorchestrator.field.orders.title')}
        }
    },
    plusstatistic: {
        name: i18n('DeleteData.service.plusstatistic.title'),
        description: i18n('DeleteData.service.plusstatistic.description'),
        fields: {
            PLUS_STATISTICS: {title: i18n('DeleteData.service.plusstatistic.field.PLUS_STATISTICS.title')}
        }
    },
    xmlsearch: {
        name: i18n('DeleteData.service.xmlsearch.title'),
        description: i18n('DeleteData.service.xmlsearch.description'),
        fields: {
            1: {title: i18n('DeleteData.service.xmlsearch.field.general.title')}
        }
    },
    toloka: {
        name: i18n('DeleteData.service.toloka.title'),
        description: i18n('DeleteData.service.toloka.description'),
        fields: {
            0: {
                title: i18n('DeleteData.service.toloka.field.user.title'),
                hasLink: true,
                links: {
                    test: 'https://tlkback-1478.admin.toloka.tst.yandex.%tld/profile/edit',
                    prod: '' // wait
                }
            }
        }
    },
    afishadata: {
        name: i18n('DeleteData.service.afisha.title'),
        description: i18n('DeleteData.service.afisha.description'),
        fields: {
            1: {title: i18n('DeleteData.service.afisha.field.orders.title')},
            2: {title: i18n('DeleteData.service.afisha.field.afisha_user.title')}
        }
    },
    navigator: {
        name: i18n('DeleteData.service.navigator.title'),
        description: i18n('DeleteData.service.navigator.description'),
        fields: {
            'points-history': {title: i18n('DeleteData.service.navigator.field.points-history.title')},
            ynavisync: {title: i18n('DeleteData.service.navigator.field.ynavisync.title')},
            ynavicarinfo: {title: i18n('DeleteData.service.navigator.field.ynavicarinfo.title')}
        },
        group: 'geo'
    },
    mapshistory: {
        name: i18n('DeleteData.service.mapshistory.title'),
        description: i18n('DeleteData.service.mapshistory.description'),
        fields: {
            bookmarks: {title: i18n('DeleteData.service.mapshistory.field.bookmarks.title')},
            'search-history': {title: i18n('DeleteData.service.mapshistory.field.search-history.title')},
            addresses: {title: i18n('DeleteData.service.mapshistory.field.addresses.title')},
            ridehistory: {title: i18n('DeleteData.service.mapshistory.field.ridehistory.title')}
        },
        group: 'geo'
    },
    mapsbooking: {
        name: i18n('DeleteData.service.mapsbooking.title'),
        description: i18n('DeleteData.service.mapsbooking.description'),
        fields: {
            bookings: {title: i18n('DeleteData.service.mapsbooking.field.bookings.title')}
        },
        group: 'geo'
    },
    webmaster: {
        name: i18n('DeleteData.service.webmaster.title'),
        description: i18n('DeleteData.service.webmaster.description'),
        fields: {
            1: {title: i18n('DeleteData.service.webmaster.field.general.title')}
        }
    }
};

const reduceGroups = (group) =>
    Object.entries(services).reduce((acc, [key, value]) => {
        if (value.group === group) {
            acc.push(key);
        }

        return acc;
    }, []);

export const groups = {
    geo: {
        name: i18n('DeleteData.group.geo.title'),
        items: reduceGroups('geo')
    }
};
