import {
    DELETE_DATA_SET_DATA,
    DELETE_DATA_SET_ERROR,
    DELETE_DATA_MERGE_DATA,
    DELETE_DATA_SET_READINESS,
    DELETE_DATA_MERGE_SERVICE_DATA,
    DELETE_DATA_SHOW_RELOAD_DRAWER,
    DELETE_DATA_SET_SERVICE_ITEM_ERROR,
    DELETE_DATA_SET_SERVICE_ITEMS_ERROR,
    DELETE_DATA_CLEAR_SERVICE_ITEMS_ERROR,
    DELETE_DATA_SET_SERVICE_ITEM_LOADING,
    DELETE_DATA_SET_SERVICE_ITEMS_LOADING,
    DELETE_DATA_SET_SERVICES_IN_PROGRESS,
    DELETE_DATA_SHOW_CUSTOM_ERROR_POPUP,
    DELETE_DATA_HIDE_CUSTOM_ERROR_POPUP
} from './constants';

const reducers = {
    [DELETE_DATA_SHOW_CUSTOM_ERROR_POPUP]: (state, {payload: {error, service} = {}}) => ({
        ...state,
        customErrorPopup: {error, service}
    }),
    [DELETE_DATA_HIDE_CUSTOM_ERROR_POPUP]: (state) => ({...state, customErrorPopup: null}),
    [DELETE_DATA_SHOW_RELOAD_DRAWER]: (state) => ({
        ...state,
        isReloadDrawerVisible: true
    }),
    [DELETE_DATA_SET_DATA]: (state, {data}) => ({
        ...state,
        data
    }),
    [DELETE_DATA_SET_ERROR]: (state, {error}) => ({
        ...state,
        error
    }),
    [DELETE_DATA_SET_SERVICES_IN_PROGRESS]: (state, {servicesInProgress}) => ({
        ...state,
        servicesInProgress
    }),
    [DELETE_DATA_MERGE_DATA]: (state, {data}) => ({
        ...state,
        data: {
            ...state.data,
            ...data
        }
    }),
    [DELETE_DATA_MERGE_SERVICE_DATA]: (state, {data}) => ({
        ...state,
        data: Object.entries(state.data).reduce((acc, [key, value]) => {
            acc[key] = !data[key]
                ? value
                : value.reduce((acc2, value2) => {
                      const toMerge = data[key][value2.id];

                      acc2.push(
                          !toMerge
                              ? value2
                              : {
                                    ...value2,
                                    ...toMerge
                                }
                      );
                      return acc2;
                  }, []);

            return acc;
        }, {})
    }),
    [DELETE_DATA_SET_SERVICE_ITEM_ERROR]: (state, {id, service, error}) => ({
        ...state,
        errorServiceItems: {
            ...state.errorServiceItems,
            [service]: {
                ...(state.errorServiceItems[service] || {}),
                [id]: error
            }
        }
    }),
    [DELETE_DATA_SET_SERVICE_ITEMS_ERROR]: (state, {ids, service, error}) => {
        if (!error && !state.errorServiceItems[service]) {
            return state;
        }

        const currentItemErrors = state.errorServiceItems[service] || {};
        const changed = ids.reduce((acc, id) => {
            if (error || currentItemErrors[id]) {
                acc[id] = error;
            }

            return acc;
        }, {});

        return !Object.keys(changed).length
            ? state
            : {
                  ...state,
                  errorServiceItems: {
                      ...state.errorServiceItems,
                      [service]: {
                          ...currentItemErrors,
                          ...changed
                      }
                  }
              };
    },
    [DELETE_DATA_CLEAR_SERVICE_ITEMS_ERROR]: (state, {service}) => {
        if (!state.errorServiceItems[service]) {
            return state;
        }

        const errorServiceItems = {...state.errorServiceItems};

        delete errorServiceItems[service];

        return {
            ...state,
            errorServiceItems
        };
    },
    [DELETE_DATA_SET_SERVICE_ITEM_LOADING]: (state, {id, service, loading}) => ({
        ...state,
        loadingServiceItems: {
            ...state.loadingServiceItems,
            [service]: {
                ...(state.loadingServiceItems[service] || {}),
                [id]: loading
            }
        }
    }),
    [DELETE_DATA_SET_SERVICE_ITEMS_LOADING]: (state, {ids, service, loading}) => ({
        ...state,
        loadingServiceItems: {
            ...state.loadingServiceItems,
            [service]: {
                ...(state.loadingServiceItems[service] || {}),
                ...ids.reduce((acc, id) => {
                    acc[id] = loading;
                    return acc;
                }, {})
            }
        }
    }),
    [DELETE_DATA_SET_READINESS]: (state, {ready}) => ({
        ...state,
        ready
    })
};

export default (state = {}, action) => (reducers[action.type] ? reducers[action.type](state, action) : state);
