import {services} from './info';

export const processServiceItems = (service, items) => {
    const serviceInfo = services[service];

    if (!serviceInfo || !Array.isArray(items) || !items.length) {
        return null;
    }

    const fields = items.reduce((acc, cur) => {
        const field = serviceInfo.fields[cur.id];

        if (field) {
            acc.push({
                ...cur,
                ...field
            });
        }

        return acc;
    }, []);

    return !fields.length
        ? null
        : {
              ...serviceInfo,
              fields
          };
};
