import './GlobalError.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Title} from '@components/Title';
import {Description} from '@components/Description';
import {Button} from '@components/Button';
import metrika from '@blocks/metrics';
import {MODE_BROWSER} from '@blocks/SignUp/modes/constants';
import {isRegisterProcess} from '@blocks/UserEntryFlow/utils';

const b = cn('GlobalError');

class GlobalError extends React.PureComponent {
    componentDidMount() {
        const {error = {}} = this.props;
        const {code, field} = error;

        metrika.send(`Показ экрана ошибки - ${field}:${code}`);
    }

    getTitle = () => {
        const {error = {}} = this.props;
        const {code, text, process} = error;

        if (isRegisterProcess(process) && code !== 'sessionidoverflow') {
            return i18n('_AUTH_.registration.step.globalerror.title');
        }

        return text;
    };

    getDescription = () => {
        const {error = {}} = this.props;
        const {code, text, errorDescription, process} = error;

        if (isRegisterProcess(process) && code !== 'sessionidoverflow') {
            return text;
        }

        if (code === 'sessionidoverflow' || errorDescription) {
            return errorDescription;
        }
    };

    getButtonSize = () => {
        const {place} = this.props;

        if (place === MODE_BROWSER) {
            return 'xm';
        }

        return 'l';
    };

    getTitleSize = () => {
        const {place} = this.props;

        if (place === MODE_BROWSER) {
            return 'l';
        }
    };

    getButtonText = () => {
        const {error = {}} = this.props;
        const {field} = error;

        if (this.shouldGoToAuth()) {
            if (field === 'findAccountsByNameAndPhone') {
                return i18n('_AUTH_.RestoreLogin.signin_with_another_account');
            }

            if (field === 'neoPhonishAuth') {
                return i18n('_AUTH_.common.back');
            }
        }

        return i18n('_AUTH_.registration.btn.retry');
    };

    shouldGoToAuth = () => {
        const {error = {}} = this.props;
        const {code} = error;

        return code === 'rate.limit_exceeded';
    };

    onClick = () => {
        const {onRestart, switchToModeAddingAccount, process} = this.props;

        if (this.shouldGoToAuth()) {
            metrika.send('Клик на кнопку перехода на экран добавления аккаунта из состояния ошибки');
            return switchToModeAddingAccount();
        }

        if (typeof onRestart === 'function') {
            metrika.send(`Клик на перезапуск процесса (${process}) из состояния ошибки`);
            return onRestart();
        }
    };

    maybeRenderControls = () => {
        const {onRestart} = this.props;

        if (typeof onRestart !== 'function' && !this.shouldGoToAuth()) {
            return null;
        }

        return (
            <div className={b('controls')}>
                <Button
                    onClick={this.onClick}
                    text={this.getButtonText()}
                    size={this.getButtonSize()}
                    type='button'
                    width='max'
                />
            </div>
        );
    };

    render() {
        return (
            <div className={b()}>
                <div className={b('body')}>
                    <Title size={this.getTitleSize()}>{this.getTitle()}</Title>
                    <Description>
                        <span dangerouslySetInnerHTML={{__html: this.getDescription()}} />
                    </Description>
                </div>

                {this.maybeRenderControls()}
            </div>
        );
    }
}

GlobalError.propTypes = {
    switchToModeAddingAccount: PropTypes.func.isRequired,
    onRestart: PropTypes.func,
    error: PropTypes.shape({
        text: PropTypes.string.isRequired,
        errorDescription: PropTypes.string,
        code: PropTypes.string.isRequired
    }),
    place: PropTypes.string,
    process: PropTypes.string
};

export {GlobalError};
