import {connect} from 'react-redux';
import {getProcessName} from '@blocks/UserEntryFlow/utils';
import switchToModeAddingAccount from '@blocks/authv2/actions/switchToModeAddingAccount';
import {GlobalError} from './GlobalError.jsx';

const mapStateToProps = (state = {}) => ({process: getProcessName(state)});

const mapDispatchToProps = {
    switchToModeAddingAccount
};

const ConnectedGlobalError = connect(mapStateToProps, mapDispatchToProps)(GlobalError);

export {ConnectedGlobalError as GlobalError};
