import './PersonalData.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {Title} from '@components/Title';
import {Field} from '@components/Field';
import {FIELDS_NAMES} from '@components/Field/names';
import {Button} from '@components/Button';
import {classNames} from '@blocks/utils';
import metrika from '@blocks/metrics';
import {isRestoreProcess} from '@blocks/UserEntryFlow/utils';

const b = classNames('PersonalDataSignUpInDaHouse');

class PersonalData extends React.PureComponent {
    static defaultProps = {
        fields: [FIELDS_NAMES.FIRSTNAME, FIELDS_NAMES.LASTNAME]
    };

    ref = React.createRef();

    componentDidMount() {
        metrika.send('Показ экрана ввода ФИ');
        this.ref.current.focus();
    }

    getTitle = () => {
        const {process} = this.props;

        if (isRestoreProcess(process)) {
            return i18n('_AUTH_.restore.step.fio.title');
        }

        return i18n('_AUTH_.registration.step.fio.title');
    };

    render() {
        const {fields, onConfirm, loading, buttonView} = this.props;

        return (
            <div className={b('')}>
                <div className={b('head')}>
                    <Title>{this.getTitle()}</Title>
                </div>

                <div className={b('body')}>
                    {fields.map((name, index) => (
                        <Field
                            size='l'
                            key={`reg-presonaldata-field-${index}`}
                            name={name}
                            ref={index === 0 ? this.ref : null}
                            shouldValidate={true}
                            view='big-input'
                        />
                    ))}
                </div>

                <div className={b('controls')}>
                    <Button
                        text={i18n('_AUTH_.next')}
                        onClick={onConfirm}
                        width='max'
                        size='l'
                        type='submit'
                        view={buttonView}
                        disabled={loading}
                    />
                </div>
            </div>
        );
    }
}

PersonalData.propTypes = {
    fields: PropTypes.arrayOf(PropTypes.string),
    onConfirm: PropTypes.func.isRequired,
    process: PropTypes.string,
    loading: PropTypes.bool,
    buttonView: PropTypes.string
};

export {PersonalData};
