import {connect} from 'react-redux';
import {PersonalData} from './PersonalData.jsx';
import {getProcessName} from '@blocks/UserEntryFlow/utils';

const ConnectedPersonalData = connect((state) => {
    const {auth = {}, customs = {}} = state;
    const {loading} = auth;

    return {
        process: getProcessName(state),
        loading,
        buttonView: customs.buttonView
    };
})(PersonalData);

export {ConnectedPersonalData as PersonalData};
