import './Phone.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Title} from '@components/Title';
import {Button} from '@components/Button';
import {RadioButton} from '@components/RadioButton';
import {Phone as PhoneField} from '@components/Phone';
import {ChildishRegLanding} from '@blocks/registration/childishRegLanding';
import {isRestoreProcess} from '@blocks/UserEntryFlow/utils';
import {FIELDS_NAMES} from '@components/Field/names';
import metrika from '@blocks/metrics';

const b = cn('Phone');

const VIEW_RADIO_OPTIONS = [
    {value: 'default', children: i18n('_AUTH_.reg-childish-radio.option.1'), 'data-t': 'phone:view:default'},
    {
        value: 'childishLanding',
        children: i18n('_AUTH_.reg-childish-radio.option.2'),
        'data-t': 'phone:view:childishLanding'
    }
];

class Phone extends React.PureComponent {
    state = {
        view: 'default'
    };
    ref = React.createRef();

    componentDidMount() {
        metrika.send('Показ экрана ввода телефона');
        this.ref.current && this.ref.current.focus();
        this.props.onMount && this.props.onMount();
    }

    getTitle = () => {
        const {process, isAmModePhonish, isWhiteLabel, title} = this.props;

        if (title) {
            return title;
        }

        if (isAmModePhonish || isWhiteLabel) {
            return i18n('_AUTH_.registration.step.phone.title');
        }

        if (isRestoreProcess(process)) {
            return i18n('_AUTH_.phone_title_id');
        }

        return i18n('_AUTH_.registration.id_text');
    };

    handleViewRadio = (evt = {}) => {
        const {currentTarget: {value} = {}} = evt;

        this.setState({view: value});
    };

    childishLandingHandler = () => {
        const {familyChildishRegOriginUrl} = this.props;

        window.location.href = familyChildishRegOriginUrl;
    };

    renderChildishLanding = () => {
        return (
            <div className={b('childishLanding')}>
                <ChildishRegLanding onNextButtonClick={this.childishLandingHandler} showTitle={false} />
            </div>
        );
    };

    renderForm = () => {
        const {
            onConfirm,
            skipInput,
            isExpNoPhoneAuthComplete,
            switchToModePreRegister,
            onNoPhoneClick,
            canSkipPhone,
            isSwitchRegisterExp,
            loading,
            buttonText,
            buttonView,
            errorText,
            hasRoundViewExp
        } = this.props;
        const btnNextId = 'passp:phone:controls:next';
        const btnRegId = 'passp:phone:controls:switch';

        return (
            <div className={b('body')}>
                {!skipInput && (
                    <PhoneField
                        name={FIELDS_NAMES.PHONE}
                        ref={this.ref}
                        hasPhoneMask={hasRoundViewExp}
                        view={hasRoundViewExp ? 'rounded-corner' : 'big-input'}
                        size='l'
                    />
                )}

                {skipInput && errorText && <div className={b('error')}>{errorText}</div>}

                <div className={b('controls')}>
                    <Button
                        text={buttonText || i18n('_AUTH_.next')}
                        onClick={onConfirm}
                        width='max'
                        size='l'
                        type='submit'
                        view={buttonView}
                        id={btnNextId}
                        dataT={btnNextId}
                        disabled={loading}
                    />

                    {isExpNoPhoneAuthComplete && (isSwitchRegisterExp || canSkipPhone) && (
                        <Button
                            text={i18n('_AUTH_.no.phone')}
                            onClick={
                                (isSwitchRegisterExp && switchToModePreRegister) || (canSkipPhone && onNoPhoneClick)
                            }
                            view='pseudo'
                            type='button'
                            dataT={btnRegId}
                            id={btnRegId}
                            disabled={loading}
                            width='max'
                            size='l'
                        />
                    )}
                </div>
            </div>
        );
    };

    render() {
        const {hideHead, showChildishLanding} = this.props;
        const {view} = this.state;

        return (
            <div className={b()}>
                {!hideHead && (
                    <div className={b('head')}>
                        <Title>{this.getTitle()}</Title>
                    </div>
                )}
                {showChildishLanding && (
                    <div className={b('radio')}>
                        <RadioButton
                            width='max'
                            value={view}
                            options={VIEW_RADIO_OPTIONS}
                            onChange={this.handleViewRadio}
                        />
                    </div>
                )}
                {view === 'default' && this.renderForm()}
                {view === 'childishLanding' && showChildishLanding && this.renderChildishLanding()}
            </div>
        );
    }
}

Phone.propTypes = {
    onConfirm: PropTypes.func.isRequired,
    onMount: PropTypes.func,
    place: PropTypes.string,
    isExpNoPhoneAuthComplete: PropTypes.bool.isRequired,
    isSwitchRegisterExp: PropTypes.bool.isRequired,
    switchToModePreRegister: PropTypes.func.isRequired,
    onNoPhoneClick: PropTypes.func,
    canSkipPhone: PropTypes.bool,
    process: PropTypes.string,
    loading: PropTypes.bool,
    isAmModePhonish: PropTypes.bool,
    isWhiteLabel: PropTypes.bool,
    buttonView: PropTypes.string,
    title: PropTypes.string,
    buttonText: PropTypes.string,
    skipInput: PropTypes.bool,
    errorText: PropTypes.string,
    hideHead: PropTypes.bool,
    showChildishLanding: PropTypes.bool,
    familyChildishRegOriginUrl: PropTypes.string,
    hasRoundViewExp: PropTypes.bool
};

export {Phone};
