import {connect} from 'react-redux';
import {Phone} from './Phone.jsx';
import {hasExp, isAuthRegSqSaExp, isAuthComplete} from '@blocks/selectors';
import switchToModePreRegister from '@blocks/authv2/actions/switchToModePreRegister';
import {noPhoneAction} from '@blocks/authv2/actions/registration/noPhoneAction';
import {toggleHumanConfirmation} from '@blocks/authv2/actions/registration/toggleHumanConfirmation';
import {getProcessName} from '@blocks/UserEntryFlow/utils';
import {ENTRY_REGISTER_PROCESS, ENTRY_REGISTER_NO_PHONE_PROCESS} from '@blocks/UserEntryFlow/processes';
import {amRequestPhoneNumberHint} from '@blocks/authv2/actions/nativeMobileApi';
import {changeProcess} from '@blocks/UserEntryFlow/actions/index.js';

const mapStateToProps = (state = {}) => {
    const {
        auth = {},
        customs: {isWhiteLabel = false, buttonView, completeReg = {}} = {},
        am = {},
        form: {errors} = {},
        common = {},
        phones = {}
    } = state;
    const {
        phone: {text: errorText}
    } = errors;
    const loading = auth.loading || phones.isLoading;
    const process = getProcessName(state);
    const {familyChildishRegOriginUrl} = common;

    return {
        isExpNoPhoneAuthComplete: hasExp(state, 'exp-no-phone-auth-complete'),
        isSwitchRegisterExp: hasExp(state, 'register-with-suggest-to-restore-by-phone-in-da-house-lite'),
        process,
        canSkipPhone:
            (isAuthRegSqSaExp(state) && [ENTRY_REGISTER_PROCESS, ENTRY_REGISTER_NO_PHONE_PROCESS].includes(process)) ||
            (isAuthComplete(state) && !completeReg.phoneConfirmationRequired),
        loading,
        isWhiteLabel,
        buttonView,
        isAmModePhonish: am.isAm && am.mode === 'phonish',
        errorText,
        familyChildishRegOriginUrl,
        hasRoundViewExp: hasExp(state, 'rounded-input-exp')
    };
};

const mapDispatchToProps = (dispatch, ownProps) => {
    return {
        switchToModePreRegister: () => {
            dispatch(switchToModePreRegister());
        },
        onNoPhoneClick: () => {
            dispatch(noPhoneAction());
        },
        onConfirm: (...args) => {
            dispatch((dispatch, getState) => {
                const state = getState();
                const process = getProcessName(state);

                if (isAuthRegSqSaExp(state) && [ENTRY_REGISTER_NO_PHONE_PROCESS].includes(process)) {
                    dispatch(toggleHumanConfirmation('phone'));
                    dispatch(changeProcess(ENTRY_REGISTER_PROCESS));
                }
            });
            ownProps.onConfirm(...args);
        },
        onMount: () => {
            dispatch(amRequestPhoneNumberHint());
        }
    };
};

const ConnectedPhone = connect(mapStateToProps, mapDispatchToProps)(Phone);

export {ConnectedPhone as Phone};
