import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {Field} from '@components/Field';
import {FIELDS_NAMES} from '@components/Field/names';
import {Button} from '@components/Button';
import {Password} from '@components/Password';
import {cn} from '@bem-react/classname';

import './PhoneAdd.styl';
import {TimeLeftTicker} from '@components/TimeLeftTicker';

const b = cn('PhoneAdd');

export class PhoneAdd extends PureComponent {
    state = {
        showTimer: false
    };

    hideTimer = () => this.setState({showTimer: false});

    showTimer = () => this.setState({showTimer: true});

    sendCode = (event) => {
        const {phone} = this.props;

        if (event) {
            event.preventDefault();
        }

        this.props.setPhoneProcessType('bind');
        this.props.sendCode(phone);
        this.showTimer();
    };

    sendCodeAgain = () => {
        this.props.resendCode();
        this.showTimer();
    };

    renderCodeConfirmation = () => {
        const {phone, isLoading} = this.props;

        return (
            <div className={b('codeConfirmation')}>
                <div className={b('description')}>
                    {i18n('ProfileSecurity.security.phone_code-sent').replace('%phone', phone)}
                </div>
                <div className={b('enterCode')}>
                    <div className={b('enterCodeInput')}>
                        <Field size='l' options={{inputMode: 'numeric'}} name={FIELDS_NAMES.PHONE_CODE} />
                    </div>
                    {this.state.showTimer ? (
                        <>
                            <span className={b('sendCodeAgain')}>
                                {i18n('ProfileSecurity.security.ask_code-again')}
                                {'  '}
                                <TimeLeftTicker tickCount={30} onTickEnd={this.hideTimer} />
                            </span>
                        </>
                    ) : (
                        <button
                            data-t='send-code-again-btn'
                            className={b('sendCodeAgainBtn')}
                            type='button'
                            onClick={this.sendCodeAgain}
                            disabled={isLoading}
                        >
                            {i18n('ProfileSecurity.security.ask_code-again_btn')}
                        </button>
                    )}
                </div>

                <div className={b('enterPassword')}>
                    <Password label={i18n('_AUTH_.security.enter_pwd_label')} />
                </div>
            </div>
        );
    };

    render() {
        const {hasCodeSent, isInProgress, phonePlaceholder, isLoading} = this.props;

        if (hasCodeSent || isInProgress) {
            return this.renderCodeConfirmation();
        }

        return (
            <div className={b('form')}>
                <div className={b('enterNumber')}>
                    <div className={b('input')}>
                        <Field
                            size='l'
                            options={{inputMode: 'tel'}}
                            placeholder={phonePlaceholder}
                            name={FIELDS_NAMES.PHONE}
                            type='tel'
                        />
                    </div>
                    <div className={b('sendCodeBtn')}>
                        <Button
                            dataT='phone-send-code'
                            size='l'
                            view='action'
                            type='submit'
                            onClick={this.sendCode}
                            progress={isLoading}
                        >
                            {i18n('ProfileSecurity.security.bind-phone_btn')}
                        </Button>
                    </div>
                </div>
                <div className={b('description')}>{i18n('ProfileSecurity.security.add-phone_description')}</div>
            </div>
        );
    }
}

PhoneAdd.propTypes = {
    denyResendUntil: PropTypes.number,
    phone: PropTypes.string,
    phonePlaceholder: PropTypes.string,
    sendCode: PropTypes.func.isRequired,
    resendCode: PropTypes.func.isRequired,
    setPhoneProcessType: PropTypes.func.isRequired,
    hasCodeSent: PropTypes.bool,
    isLoading: PropTypes.bool,
    isInProgress: PropTypes.bool,
    isMobile: PropTypes.bool
};
