import {connect} from 'react-redux';
import {PhoneAdd} from './PhoneAdd.jsx';
import {getFormValues, isMobile} from '@blocks/selectors';
import {resendCode} from '@blocks/actions/phone/phoneProcess';
import {sendCode} from '@blocks/actions/phone/phoneBind';
import {PHONE_PLACEHOLDERS, setPhoneProcessType} from '@blocks/actions/phone/index';

const mapStateToProps = (state = {}) => {
    const {settings = {}, isLoading, phoneProcess = {}} = state;
    const formValues = getFormValues(state);
    const {phone} = formValues;
    const {tld} = settings;
    const {isInProgress, hasCodeSent, hasCodeChecked, operationId, phonesList} = phoneProcess;
    const getCurrentPhone = () =>
        phonesList ? phonesList.find((tel) => tel.operationId === operationId).number : phone;

    return {
        phone: isInProgress ? getCurrentPhone() : phone,
        isInProgress,
        hasCodeSent,
        hasCodeChecked,
        phonePlaceholder: PHONE_PLACEHOLDERS[tld] || i18n('AuthChallenges.challenges.phone-placeholder'),
        isLoading,
        isMobile: isMobile(state)
    };
};

const mapDispatchToProps = {
    sendCode,
    resendCode,
    setPhoneProcessType
};

const ConnectedPhoneAdd = connect(mapStateToProps, mapDispatchToProps)(PhoneAdd);

export {ConnectedPhoneAdd as PhoneAdd};
