import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Phone} from '@screens/Phone';
import {PhoneConfirmation} from '@screens/PhoneConfirmation';
import {CloseIcon} from '../../LoginMethod/Icons/CloseIcon';

import './PhoneBindConfirm.styl';

const b = cn('PhoneBindConfirm');

const TEXTS = {
    TITLE: {
        family: i18n('Frontend.phone-bind-confirm.title-step1.family'),
        profileAuthBlock: i18n('Frontend.phone-bind-confirm.title-step1.profileAuthBlock')
    },
    DESCRIPTION: {
        family: i18n('Frontend.phone-bind-confirm.desc-step1.family')
    },
    WARNING: {
        family: i18n('Frontend.phone-bind-confirm.warining-step1.family')
    },
    BUTTON: {
        profileAuthBlock: i18n('Frontend.phone.confrim-btn.profileAuthBlock')
    }
};

export class PhoneBindConfirm extends PureComponent {
    sendCode = (event) => {
        const {submitConfirmation, phoneId} = this.props;

        event && event.preventDefault();

        if (phoneId) {
            return submitConfirmation(phoneId);
        }

        submitConfirmation();
    };

    checkCode = (event) => {
        const {commitConfirmation, phoneId, phoneCode, onSuccess} = this.props;

        event.preventDefault();

        if (phoneId) {
            return commitConfirmation(phoneCode, true, undefined, onSuccess);
        }

        commitConfirmation(phoneCode, true, 'confirmAndBindSecure', onSuccess);
    };

    render() {
        const {isConfirmationCodeSent, numberSreenTexts, hasSecuredPhone, closeModal, isTouch, place} = this.props;

        if (isConfirmationCodeSent) {
            return (
                <div className={b()}>
                    <button type='button' className={b('close', {isTouch})} onClick={closeModal}>
                        <CloseIcon />
                    </button>

                    <div className={b('title')}>{i18n('Frontend.phone-bind-confirm.title-step2')}</div>

                    <form method='post' onSubmit={this.checkCode}>
                        <PhoneConfirmation
                            isAutoSubmitPrevent={true}
                            isBindProcess={!hasSecuredPhone}
                            buttonText={i18n('Frontend.ready')}
                            onConfirm={this.checkCode}
                            onRetry={this.sendCode}
                        />
                    </form>
                </div>
            );
        }

        const warningText = TEXTS.WARNING[place];

        return (
            <div className={b()}>
                <button type='button' className={b('close', {isTouch})} onClick={closeModal}>
                    <CloseIcon />
                </button>
                {['family'].includes(place) && <div className={b('icon', {[place]: true})} />}
                <div className={b('title')}>
                    {TEXTS.TITLE[place] || i18n('Frontend.phone-bind-confirm.title-step1')}
                </div>
                <form method='post' onSubmit={this.sendCode}>
                    <Phone
                        title={TEXTS.DESCRIPTION[place] || numberSreenTexts.title}
                        skipInput={hasSecuredPhone}
                        buttonText={TEXTS.BUTTON[place] || numberSreenTexts.buttonText}
                        onConfirm={this.sendCode}
                        onRetry={this.sendCode}
                    />
                </form>
                {['family'].includes(place) && (
                    <div className={b('warning')}>
                        <div className={b('warningIcon')} />
                        <div className={b('warningText')}>{warningText}</div>
                    </div>
                )}
            </div>
        );
    }
}

PhoneBindConfirm.propTypes = {
    isConfirmationCodeSent: PropTypes.bool,
    phone: PropTypes.string,
    phoneCode: PropTypes.string,
    place: PropTypes.string,
    phoneId: PropTypes.number,
    hasSecuredPhone: PropTypes.bool,
    numberSreenTexts: PropTypes.object,
    submitConfirmation: PropTypes.func.isRequired,
    commitConfirmation: PropTypes.func.isRequired,
    onSuccess: PropTypes.func,
    closeModal: PropTypes.func,
    isTouch: PropTypes.bool
};
