import React, {PureComponent} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';
import {PhoneBindConfirm} from './';
import {setEditMode} from '@blocks/common/actions';
import {resetPhoneBindConfirm} from './actions';
import {clearForm} from '@blocks/actions/form';
import Modal from '@components/Wrappers/Modal.jsx';
import {cn} from '@bem-react/classname';
import './PhoneBindConfirm.styl';

const b = cn('PhoneBindConfirmModal');

class PhoneBindConfirmModal extends PureComponent {
    componentDidMount() {
        const {isSms2faEnabled, is2faEnabled, setEditMode, completeSms2fa} = this.props;

        if (!isSms2faEnabled && !is2faEnabled && completeSms2fa) {
            setEditMode('phoneBindConfirm');
        }
    }

    cleanup = (editMode, cb) => {
        const {setEditMode, resetPhoneBindConfirm, clearForm} = this.props;

        setEditMode(editMode);
        resetPhoneBindConfirm();
        clearForm();
        typeof cb === 'function' && cb();
    };

    closeModal = () => {
        const {onClose} = this.props;

        this.cleanup('', onClose);
    };

    onSuccess = () => {
        const {editModeOnSuccess = '', onSuccess} = this.props;

        this.cleanup(editModeOnSuccess, onSuccess);
    };

    render() {
        const {isOpened, isTouch, place} = this.props;

        return (
            <Modal visible={isOpened} dataT='phone-bind-confirm-modal' className={b({isTouch})}>
                {isOpened && (
                    <PhoneBindConfirm
                        place={place}
                        isModal={true}
                        isTouch={isTouch}
                        closeModal={this.closeModal}
                        isOpened={isOpened}
                        onSuccess={this.onSuccess}
                    />
                )}
            </Modal>
        );
    }
}

PhoneBindConfirmModal.propTypes = {
    isOpened: PropTypes.bool.isRequired,
    setEditMode: PropTypes.func.isRequired,
    resetPhoneBindConfirm: PropTypes.func.isRequired,
    clearForm: PropTypes.func.isRequired,
    onSuccess: PropTypes.func,
    onClose: PropTypes.func,
    place: PropTypes.string,
    editModeOnSuccess: PropTypes.string,
    isTouch: PropTypes.bool.isRequired,
    isSms2faEnabled: PropTypes.bool,
    is2faEnabled: PropTypes.bool,
    completeSms2fa: PropTypes.bool
};

const mapStateToProps = (state = {}) => {
    const {
        common = {},
        settings = {},
        access: {isSms2faEnabled = false, is2faEnabled = false} = {},
        phones: {completeSms2fa = false} = {}
    } = state;
    const {ua: {isTouch} = {}} = settings;
    const {edit} = common;

    return {
        isOpened: edit === 'phoneBindConfirm',
        isTouch,
        isSms2faEnabled,
        is2faEnabled,
        completeSms2fa
    };
};

const mapDispatchToProps = {
    setEditMode,
    resetPhoneBindConfirm,
    clearForm
};

const ConnectedPhoneBindConfirmModal = connect(mapStateToProps, mapDispatchToProps)(PhoneBindConfirmModal);

export {ConnectedPhoneBindConfirmModal as PhoneBindConfirmModal};
