import api from '@blocks/api';
import {updateErrors} from '@blocks/actions/form';
import {FIELDS_NAMES} from '@components/Field/names';
import {getError} from '@blocks/utils';
import {setPhoneConfirmationPhoneCheckState} from '@blocks/actions/phoneConfirm';
import {toggleSms2fa} from './toggleSms2fa';
import {getAccountPhones} from './getAccountPhones';
import {getFormValues, getTrackId} from '@blocks/selectors';
import {TRACK_TYPES} from '@blocks/actions/tracks';

export function commitConfirmation(code, shouldSms2faEnable, mode, callback) {
    return (dispatch, getState) => {
        const state = getState();
        const {phoneConfirm: {isPasswordRequired} = {}} = state;
        const trackId = getTrackId(state, TRACK_TYPES.COMMON);
        const password = getFormValues(state).password;

        if (!password && isPasswordRequired) {
            dispatch(
                updateErrors({
                    field: FIELDS_NAMES.PASSWORD,
                    error: getError(FIELDS_NAMES.PASSWORD, 'missingvalue_current')
                })
            );
            return;
        }

        api.checkPhoneConfirmationCode({trackId, code, mode, password})
            .then((response = {}) => {
                if (response.status === 'ok') {
                    dispatch(getAccountPhones());

                    if (shouldSms2faEnable) {
                        return dispatch(toggleSms2fa(callback));
                    }

                    if (typeof callback === 'function') {
                        callback();
                    }
                }
            })
            .catch((error = {}) => {
                const code = error.errors && Array.isArray(error.errors) && error.errors[0];

                if (code === 'check_phone') {
                    return dispatch(setPhoneConfirmationPhoneCheckState(true));
                }

                if (code === 'password.not_matched') {
                    return dispatch(
                        updateErrors({field: FIELDS_NAMES.PASSWORD, error: getError(FIELDS_NAMES.PASSWORD, code)})
                    );
                }

                dispatch(
                    updateErrors({field: FIELDS_NAMES.PHONE_CODE, error: getError(FIELDS_NAMES.PHONE_CODE, code)})
                );
            });
    };
}
