import api from '@blocks/api';
import {loginMethodLoading} from '@blocks/LoginMethod/actions';
import {updateRestorePhone} from './';

export function getAccountPhones() {
    return (dispatch) => {
        dispatch(loginMethodLoading(true));
        api.request('get-account-phones')
            .done((response = {}) => {
                if (response.status === 'ok') {
                    dispatch(loginMethodLoading(false));
                    const {account: {phones = {}} = {}} = response;
                    const securePhone = Object.values(phones).find((phone) => phone.secured) || {};
                    const {id: phoneId, number: {masked_international: number} = {}} = securePhone;

                    return dispatch(updateRestorePhone({phoneId, number}));
                }
            })
            .fail(() => {
                dispatch(loginMethodLoading(false));
            });
    };
}
