import api from '@blocks/api';
import {updateTrack} from '@blocks/common/actions';
import {loginMethodLoading} from '@blocks/LoginMethod/actions';

export function initTrack() {
    return (dispatch) => {
        dispatch(loginMethodLoading(true));
        api.request('initTrack', {type: 'authorize'})
            .done((res = {}) => {
                dispatch(loginMethodLoading(false));

                if (res.status === 'ok') {
                    const {track_id: trackId} = res;

                    dispatch(updateTrack(trackId));
                }
            })
            .fail(() => {
                dispatch(loginMethodLoading(false));
            });
    };
}
