import {requestPhoneConfirmationCode, setPhoneConfirmMethod} from '@blocks/actions/phoneConfirm';

export function submitConfirmation(phoneId) {
    return (dispatch, getState) => {
        const state = getState();
        const {
            common: {track_id: trackId}
        } = state;

        dispatch(setPhoneConfirmMethod('by_sms'));

        if (phoneId) {
            requestPhoneConfirmationCode({
                dispatch,
                getState,
                trackId,
                phoneId
            });
            return;
        }

        requestPhoneConfirmationCode({
            dispatch,
            getState,
            trackId,
            mode: 'confirmAndBindSecure'
        }).catch(() => {});
    };
}
