import api from '@blocks/api';
import {getTrackId} from '@blocks/selectors';
import {TRACK_TYPES} from '@blocks/actions/tracks';
import {updateErrors} from '@blocks/actions/form';
import {loginMethodLoading} from '@blocks/LoginMethod/actions';
import {FIELDS_NAMES} from '@components/Field/names';
import {getError} from '@blocks/utils';
import {sms2faEnabled} from './';
import {initTrack} from './initTrack';

export function toggleSms2fa(callback) {
    return (dispatch, getState) => {
        const state = getState();
        const trackId = getTrackId(state, TRACK_TYPES.COMMON);
        const {access: {isSms2faEnabled = false} = {}} = state;

        dispatch(loginMethodLoading(true));

        api.request('yasms.sms2faCommit', {isEnabled: !isSms2faEnabled, track_id: trackId})
            .done((response = {}) => {
                if (response.status !== 'ok') {
                    return dispatch(
                        updateErrors({
                            field: FIELDS_NAMES.PHONE_CODE,
                            error: getError(FIELDS_NAMES.PHONE_CODE, 'global')
                        })
                    );
                }

                dispatch(sms2faEnabled(!isSms2faEnabled));
                dispatch(loginMethodLoading(false));
                dispatch(initTrack());

                if (typeof callback === 'function') {
                    callback();
                }
            })
            .fail((error = {}) => {
                dispatch(loginMethodLoading(false));
                const code = error.errors && Array.isArray(error.errors) && error.errors[0];

                dispatch(
                    updateErrors({field: FIELDS_NAMES.PHONE_CODE, error: getError(FIELDS_NAMES.PHONE_CODE, code)})
                );
            });
    };
}
