import {getFormValues} from '@blocks/selectors';
import {PhoneBindConfirm} from '@screens/PhoneBindConfirm/PhoneBindConfirm';
import {connect} from 'react-redux';
import {submitConfirmation} from './actions/submitConfirmation';
import {commitConfirmation} from './actions/commitConfirmation';

function mapStateToProps(state) {
    const {phoneConfirm: {isConfirmationCodeSent = false} = {}, phones: {restore: phonesForRestore = []} = {}} = state;
    const hasSecuredPhone = Boolean(phonesForRestore.length);
    const securedPhone = hasSecuredPhone ? phonesForRestore[0] : null;
    const {phone, phoneCode} = getFormValues(state);
    const numberSreenTexts = {
        title: hasSecuredPhone
            ? i18n('_AUTH_.phone-confirm.phone.title-with-number').replace('%phone', securedPhone.number)
            : i18n('Frontend.phone.enter-nubmer'),
        buttonText: i18n('Frontend.phone.confrim-btn')
    };

    return {
        isConfirmationCodeSent,
        phone,
        phoneCode,
        phoneId: hasSecuredPhone ? securedPhone.id : null,
        hasSecuredPhone,
        numberSreenTexts
    };
}

const mapDispatchToProps = {
    submitConfirmation,
    commitConfirmation
};

const ConnectedPhoneBindConfirm = connect(mapStateToProps, mapDispatchToProps)(PhoneBindConfirm);

export {ConnectedPhoneBindConfirm as PhoneBindConfirm};
