import {connect} from 'react-redux';
import {PhoneConfirmation} from './PhoneConfirmation.jsx';
import {updateValues, updateErrors} from '@blocks/actions/form';
import {setPhoneConfirmMethod} from '@blocks/actions/phoneConfirm';
import {getFormValues, isMobile, getFormErrors, isAndroidAm, hasExp, isKeyEnabled2FASelector} from '@blocks/selectors';
import {prettifyPhone} from '@blocks/utils';
import {FIELDS_NAMES} from '@components/Field';

const ONLY_DIGITS_REGEXP = /[^\d]+/g;
const mapStateToProps = (state = {}, {name = 'phoneCode', buttonText}) => {
    const values = getFormValues(state);
    const phoneValue = values[FIELDS_NAMES.PHONE];
    const code = values[FIELDS_NAMES.PHONE_CODE];
    const errors = getFormErrors(state);
    const {phoneConfirm = {}, auth = {}, am = {}, settings = {}, tracks = {}, common = {}, customs = {}} = state;
    const {loading} = auth;
    const {env} = settings;
    const {
        phoneConfirmMethod = 'by_sms',
        denyResendUntil,
        callingNumberTemplate,
        shouldCheckPhone,
        internationalPhoneNumber,
        phoneNumber,
        isPasswordRequired
    } = phoneConfirm;
    const phone =
        phoneNumber ||
        ((internationalPhoneNumber || '').replace(ONLY_DIGITS_REGEXP, '') === phoneValue.replace(ONLY_DIGITS_REGEXP, '')
            ? internationalPhoneNumber
            : prettifyPhone(phoneValue));

    const isKeyEnabled2FA = isKeyEnabled2FASelector(state);

    return {
        phone,
        code,
        denyResendUntil,
        confirmMethod: phoneConfirmMethod,
        error: errors[name] && errors[name].text,
        callingNumberTemplate,
        shouldCheckPhone,
        isPasswordRequired,
        isKeyEnabled2FA,
        isMobile: isMobile(state),
        loading,
        isAm: am.isAm,
        isWithCodeFormatExp: !isAndroidAm(state),
        isNotProduction: ['development', 'testing'].includes(env.type),
        trackId: tracks.registerTrackId || common.trackId,
        buttonView: customs.buttonView,
        buttonText:
            buttonText ||
            (isKeyEnabled2FA &&
                (phone && state.am.mode === 'phoneconfirm' ? i18n('Frontend.send_sms') : i18n('Frontend.next'))),
        hasRoundViewExp: hasExp(state, 'rounded-input-exp')
    };
};

const mapDispatchToProps = {
    updateValues,
    updateErrors,
    setPhoneConfirmMethod
};

const ConnectedPhoneConfirmation = connect(mapStateToProps, mapDispatchToProps)(PhoneConfirmation);

export {ConnectedPhoneConfirmation as PhoneConfirmation};
