import {connect} from 'react-redux';
import {PhoneReplace} from './PhoneReplace.jsx';
import {isMobile, getFormValues} from '@blocks/selectors';
import {resendCode} from '@blocks/actions/phone/phoneProcess';
import {sendCode} from '@blocks/actions/phone/phoneReplace';
import {PHONE_PLACEHOLDERS, togglePhoneAvailable} from '@blocks/actions/phone/index';

const mapStateToProps = (state = {}) => {
    const {settings = {}, phoneProcess = {}, isLoading} = state;
    const formValues = getFormValues(state);
    const {phone} = formValues;
    const {tld} = settings;
    const {
        hasCodeSent,
        isInProgress,
        isInQuarantine,
        quarantineDaysLeft,
        phonesList,
        isOldNumberUnAvailable,
        number,
        processedPhone
    } = phoneProcess;

    return {
        enteredPhone: phone,
        processedPhone,
        hasCodeSent,
        isInProgress,
        isInQuarantine,
        quarantineDaysLeft,
        phonesList,
        availablePhone: number,
        isOldNumberUnAvailable,
        isLoading,
        phonePlaceholder: PHONE_PLACEHOLDERS[tld] || i18n('AuthChallenges.challenges.phone-placeholder'),
        isMobile: isMobile(state)
    };
};

const mapDispatchToProps = {
    sendCode,
    resendCode,
    togglePhoneAvailable
};

const ConnectedPhoneReplace = connect(mapStateToProps, mapDispatchToProps)(PhoneReplace);

export {ConnectedPhoneReplace as PhoneReplace};
