import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {PublicId} from '@screens/PublicId';
import Modal from '@components/Wrappers/Modal.jsx';

export class PublicIdModal extends PureComponent {
    closeModal = () => {
        const {setEditMode, updateValues, updateStates} = this.props;

        setEditMode('');
        updateValues({field: 'publicId', value: ''});
        updateStates({field: 'publicId', status: ''});
    };

    render() {
        const {isOpened} = this.props;

        return (
            <Modal visible={isOpened} dataT='public-id-modal' onCloserClick={this.closeModal}>
                <PublicId isModal={true} closeModal={this.closeModal} />
            </Modal>
        );
    }
}

PublicIdModal.propTypes = {
    isOpened: PropTypes.bool.isRequired,
    setEditMode: PropTypes.func.isRequired,
    updateValues: PropTypes.func,
    updateStates: PropTypes.func
};
