import {connect} from 'react-redux';
import {PublicIdModal} from './PublicIdModal.jsx';
import {setEditMode} from '@blocks/common/actions';
import {updateValues, updateStates} from '@blocks/actions/form';

const mapStateToProps = (state = {}) => {
    const {common = {}} = state;

    return {
        isOpened: common.edit === 'PUBLIC_ID'
    };
};

const mapDispatchToProps = {
    setEditMode,
    updateValues,
    updateStates
};

const ConnectedPublicModal = connect(mapStateToProps, mapDispatchToProps)(PublicIdModal);

export {ConnectedPublicModal as PublicIDModal};
