import {connect} from 'react-redux';
import {PublicId} from './PublicId.jsx';
import {getFormValues, isMobile} from '@blocks/selectors';
import {
    validatePublicId,
    updatePublicId,
    setPublicIdVisible,
    savePublicId,
    suggestPublicId
} from '@blocks/actions/publicId';
import {updateValues} from '@blocks/actions/form';
import {setEditMode} from '@blocks/common/actions';

const mapStateToProps = (state = {}) => {
    const {settings = {}, publicId = {}, common = {}, isLoading, form, person = {}, router = {}} = state;
    const {isOpened, isEmbedded, id, hasUpdated, hasPublicIdSet, publicIdSuggest, publicIdSuggestLoading} = publicId;
    const formValues = getFormValues(state);
    const formStates = form.states;
    const publicIdVal = formValues.publicId;
    const {passportLinks = {}, tld = 'ru', isNewLayout} = settings;
    const {firstname = '', lastname = ''} = person;
    const {retpath, profilePage} = common;
    const {location = {}} = router;

    return {
        publicIdVal,
        publicIdSuggest,
        publicIdSuggestLoading,
        id: hasPublicIdSet ? id : '',
        isMobile: isMobile(state),
        tld,
        isNewLayout,
        passportLinks,
        isOpened,
        isEmbedded,
        hasUpdated,
        isLoading,
        firstname,
        lastname,
        isValid: formStates.publicId === 'valid',
        retpath: retpath || profilePage,
        hasOpenedFromProfile: location && location.pathname
    };
};

const mapDispatchToProps = {
    validatePublicId,
    updatePublicId,
    updateValues,
    savePublicId,
    setPublicIdVisible,
    setEditMode,
    suggestPublicId
};

const ConnectedPublicId = connect(mapStateToProps, mapDispatchToProps)(PublicId);

export {ConnectedPublicId as PublicId};
