import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Title} from '@components/Title';
import {Button} from '@components/Button';
import {SecurityQuestionSecurityAnswer} from '@components/SecurityQuestionSecurityAnswer';

const b = cn('SecurityQuestionSecurityAnswerScreen');

export class SecurityQuestionSecurityAnswerScreen extends React.PureComponent {
    static btnNextId = 'passp:sqsa:controls:next';

    static propTypes = {
        loading: PropTypes.bool,
        onConfirm: PropTypes.func.isRequired,
        buttonView: PropTypes.string
    };

    render() {
        const {loading, buttonView, onConfirm} = this.props;

        return (
            <div className={b()}>
                <div className={b('head')}>
                    <Title>{i18n('_AUTH_.field_hint_question_id')}</Title>
                </div>

                <SecurityQuestionSecurityAnswer />

                <div className={b('controls')}>
                    <Button
                        text={i18n('_AUTH_.next')}
                        onClick={onConfirm}
                        width='max'
                        size='l'
                        type='submit'
                        view={buttonView}
                        id={SecurityQuestionSecurityAnswer.btnNextId}
                        dataT={SecurityQuestionSecurityAnswer.btnNextId}
                        disabled={loading}
                    />
                </div>
            </div>
        );
    }
}
