import './Eula.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {Title} from '@components/Title';
import {Button} from '@components/Button';
import {BackButton} from '@components/BackButton';
import {Description} from '@components/Description';
import {classNames} from '@blocks/utils';
import metrika from '@blocks/metrics';
import {MODE_BROWSER} from '@blocks/SignUp/modes/constants';

const b = classNames('Eula');

class Eula extends React.PureComponent {
    componentDidMount() {
        metrika.send('Показ экрана с пользовательским соглашением');
    }

    _onClick = () => {
        const {onConfirm, updateValues} = this.props;

        updateValues({field: 'eula_accepted', value: 'on'});
        onConfirm();
    };

    getButtonSize = () => {
        const {place} = this.props;

        if (place === MODE_BROWSER) {
            return 'xm';
        }

        return 'l';
    };

    getTitleSize = () => {
        const {place} = this.props;

        if (place === MODE_BROWSER) {
            return 'l';
        }
    };

    maybeRenderBackButton = () => {
        const {place, goBack} = this.props;

        if (place === MODE_BROWSER) {
            return (
                <div className={b('back-button')}>
                    <BackButton onClick={goBack} place={place} />
                </div>
            );
        }
    };

    render() {
        const {eulaTexts, loading} = this.props;
        const {title, description, button} = eulaTexts;

        return (
            <div className={b()}>
                {this.maybeRenderBackButton()}

                <div className={b('head')}>
                    <Title size={this.getTitleSize()}>{title}</Title>
                    <Description>
                        <div dangerouslySetInnerHTML={{__html: description}} />
                    </Description>
                </div>

                {/*Нужен для более правильной верстки*/}
                <div className={b('body')} />

                <div className={b('controls')}>
                    <Button
                        onClick={this._onClick}
                        text={button}
                        type='button'
                        size={this.getButtonSize()}
                        disabled={loading}
                        width='max'
                    />
                </div>
            </div>
        );
    }
}

Eula.propTypes = {
    updateValues: PropTypes.func.isRequired,
    onConfirm: PropTypes.func.isRequired,
    goBack: PropTypes.func,
    place: PropTypes.string,
    eulaTexts: PropTypes.shape({
        title: PropTypes.string,
        description: PropTypes.string,
        button: PropTypes.string
    }).isRequired,
    loading: PropTypes.bool
};

export {Eula};
