import {Eula} from './Eula.jsx';
import {connect} from 'react-redux';
import {updateValues} from '@blocks/actions/form';
import {getEULATexts} from '@blocks/selectors';

const mapStateToProps = (state = {}) => {
    const {auth = {}} = state;
    const {loading} = auth;

    return {eulaTexts: getEULATexts(state), loading};
};

const mapDispatchToProps = {
    updateValues
};

const ConnectedEula = connect(mapStateToProps, mapDispatchToProps)(Eula);

export {ConnectedEula as Eula};
