import './Finish.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {Title} from '@components/Title';
import {Description} from '@components/Description';
import {Button} from '@components/Button';
import {Link} from '@components/Link';
import {classNames} from '@blocks/utils';
import {closeBalloon, showPasswordList} from '@blocks/SignUp/modes/RegistrationWithSuggestToRestoreByPhone/yabroApi';
import metrika from '@blocks/metrics';
import {MODE_BROWSER} from '@blocks/SignUp/modes/constants';

const b = classNames('Finish');

class Finish extends React.PureComponent {
    componentDidMount() {
        metrika.send('Показ экрана успеха');
    }

    showPasswordList = () => {
        if (typeof showPasswordList === 'function') {
            showPasswordList();
        }

        if (typeof closeBalloon === 'function') {
            closeBalloon();
        }

        metrika.send('Показать список паролей');
    };

    maybeRenderShowPasswordListButton = () => {
        const {isShowPasswordListButton} = this.props;

        if (!isShowPasswordListButton) {
            return null;
        }

        return (
            <Button
                view='pseudo'
                text={i18n('_AUTH_.registration.btn.showpasswd')}
                type='button'
                onClick={this.showPasswordList}
                size={this.getButtonSize()}
                width='max'
            />
        );
    };

    onChangePasswordLinkClick = () => {
        if (typeof closeBalloon === 'function') {
            closeBalloon();
        }

        metrika.send('Сменить пароль');
    };

    onOkButtonClick = () => {
        const {onConfirm} = this.props;

        metrika.send('Готово');

        if (typeof closeBalloon === 'function') {
            closeBalloon();
        }

        if (typeof onConfirm === 'function') {
            onConfirm();
        }
    };

    maybeRenderChangePasswordLink = () => {
        const {isShowPasswordListButton} = this.props;

        if (!isShowPasswordListButton) {
            return null;
        }

        return (
            <div className={b('changepass')}>
                <Link href='/profile/password' onClick={this.onChangePasswordLinkClick} target='_blank'>
                    {i18n('_AUTH_.changePassword')}
                </Link>
            </div>
        );
    };

    getButtonSize = () => {
        const {place} = this.props;

        if (place === MODE_BROWSER) {
            return 'xm';
        }

        return 'l';
    };

    getTitleSize = () => {
        const {place} = this.props;

        if (place === MODE_BROWSER) {
            return 'l';
        }
    };

    render() {
        return (
            <div className={b()}>
                <div className={b('body')}>
                    <div className={b('icon')} />
                    <Title size={this.getTitleSize()}>{i18n('_AUTH_.registration.step.finish.title')}</Title>
                    <Description>{i18n('_AUTH_.registration.step.finish.description')}</Description>
                </div>

                <div className={b('controls')}>
                    <Button
                        text={i18n('_AUTH_.registration.btn.ok')}
                        type='button'
                        onClick={this.onOkButtonClick}
                        size={this.getButtonSize()}
                        width='max'
                    />

                    {this.maybeRenderShowPasswordListButton()}
                    {this.maybeRenderChangePasswordLink()}
                </div>
            </div>
        );
    }
}

Finish.propTypes = {
    isShowPasswordListButton: PropTypes.bool.isRequired,
    onConfirm: PropTypes.func.isRequired,
    place: PropTypes.string
};

export {Finish};
