import './Login.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {Title} from '@components/Title';
import {Login} from '@components/Login';
import {LoginSuggest} from '@components/LoginSuggest';
import {Button} from '@components/Button';
import {BackButton} from '@components/BackButton';
import {classNames} from '@blocks/utils';
import metrika from '@blocks/metrics';
import {MODE_BROWSER} from '@blocks/SignUp/modes/constants';

const b = classNames('LoginSignUp');

const TITLES = {
    default: {
        hasLoginList: i18n('_AUTH_.registration.step.login.title'),
        hasNotLoginList: i18n('_AUTH_.registration.step.login.empty.suggest.title')
    },
    need_access_to_childish_registration: {
        hasLoginList: i18n('_AUTH_.registration.step.login.title.childish'),
        hasNotLoginList: i18n('_AUTH_.registration.step.login.empty.suggest.title.childish')
    }
};

class LoginSignUp extends React.PureComponent {
    state = {
        showLoginSuggest: false,
        logins: {}
    };

    componentDidMount() {
        metrika.send('Показ экрана ввода логина');
    }

    suggestedIndex = 1;
    packSize = 3;

    suggestNextPack = () => {
        const {logins = {}} = this.props;
        const newSuggestedIndex = this.suggestedIndex + this.packSize;

        let {loginsList = []} = logins;

        loginsList = loginsList.slice(this.suggestedIndex, newSuggestedIndex);

        this.suggestedIndex = newSuggestedIndex === 10 ? 1 : newSuggestedIndex;
        this.setState({
            showLoginSuggest: true,
            logins: Object.assign({}, logins, {loginsList})
        });

        metrika.send('Показать еще логины');
    };

    getFieldView = () => {
        const {place} = this.props;

        if (place === MODE_BROWSER) {
            return 'one-border';
        }

        return 'big-input';
    };

    getFieldSize = () => {
        const {place} = this.props;

        if (place === MODE_BROWSER) {
            return 'm';
        }

        return 'l';
    };

    getButtonSize = () => {
        const {place} = this.props;

        if (place === MODE_BROWSER) {
            return 'xm';
        }

        return 'l';
    };

    renderControls = () => {
        const {showLoginSuggest} = this.state;
        const {onConfirm, logins = {}, loading, buttonView} = this.props;
        const {loginsList = []} = logins;
        const loginSuggestId = 'passp:Login:suggest';
        const btnRegId = 'passp:Login:registration';

        return (
            <div className={b({controls: true, 'controls-row': !!loginsList.length})}>
                {!!loginsList.length && (
                    <Button
                        text={
                            !showLoginSuggest
                                ? i18n('_AUTH_.registration.btn.otherlogin')
                                : i18n('_AUTH_.registration.btn.norelogins')
                        }
                        onClick={this.suggestNextPack}
                        view='default'
                        type='button'
                        size={this.getButtonSize()}
                        disabled={loading}
                        width='max'
                        dataT={loginSuggestId}
                        id={loginSuggestId}
                        aria-label={
                            !showLoginSuggest
                                ? i18n('_AUTH_.registration.btn.otherlogin.aria-label')
                                : i18n('_AUTH_.registration.btn.norelogins.aria-label')
                        }
                    />
                )}

                <Button
                    onClick={onConfirm}
                    text={i18n('_AUTH_.registration.btn.great')}
                    type='submit'
                    view={buttonView}
                    size={this.getButtonSize()}
                    disabled={loading}
                    width='max'
                    dataT={btnRegId}
                    id={btnRegId}
                />
            </div>
        );
    };

    getTitleSize = () => {
        const {place} = this.props;

        if (place === MODE_BROWSER) {
            return 'l';
        }
    };

    maybeRenderBackButton = () => {
        const {place, goBack} = this.props;

        if (place === MODE_BROWSER) {
            return <BackButton onClick={goBack} place={place} />;
        }
    };

    maybeRenderTitle = () => {
        const {logins = {}, origin} = this.props;
        const {loginsList = []} = logins;
        const titleField = loginsList.length ? 'hasLoginList' : 'hasNotLoginList';
        const titleText = (TITLES[origin] || TITLES.default)[titleField];

        return <Title size={this.getTitleSize()}>{titleText}</Title>;
    };

    onLoginClick = () => {
        this.setState({showLoginSuggest: false});
        metrika.send('Выбор логина из списка');
    };

    render() {
        const {showLoginSuggest, logins} = this.state;
        const {login, getLogins, place} = this.props;

        return (
            <div className={b('')}>
                {this.maybeRenderBackButton()}

                <div className={b('head')}>
                    {this.maybeRenderTitle()}
                    <div className={b('user-avatar')} />
                </div>

                <div className={b('body')}>
                    <Login
                        hideLabel={place === MODE_BROWSER}
                        value={login}
                        shouldValidate={true}
                        view={this.getFieldView()}
                        size={this.getFieldSize()}
                    />
                    {showLoginSuggest && (
                        <LoginSuggest logins={logins} onLoginClick={this.onLoginClick} getLogins={getLogins} />
                    )}
                </div>

                {this.renderControls()}
            </div>
        );
    }
}

LoginSignUp.propTypes = {
    logins: PropTypes.shape({
        loginsList: PropTypes.arrayOf(PropTypes.string),
        isValidating: PropTypes.bool,
        isFetching: PropTypes.bool
    }),
    login: PropTypes.string,
    onConfirm: PropTypes.func.isRequired,
    getLogins: PropTypes.func.isRequired,
    goBack: PropTypes.func,
    place: PropTypes.string,
    loading: PropTypes.bool,
    buttonView: PropTypes.string,
    origin: PropTypes.string
};

export {LoginSignUp as Login};
