import './PersonalData.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {Title} from '@components/Title';
import {Field} from '@components/Field';
import {FIELDS_NAMES} from '@components/Field/names';
import {Button} from '@components/Button';
import {Phone} from '@components/Phone';
import {classNames} from '@blocks/utils';
import metrika from '@blocks/metrics';
import {MODE_BROWSER} from '@blocks/SignUp/modes/constants';

const b = classNames('PersonalDataSignUpBrowser');

class PersonalData extends React.PureComponent {
    static defaultProps = {
        fields: [FIELDS_NAMES.FIRSTNAME, FIELDS_NAMES.LASTNAME, FIELDS_NAMES.PHONE]
    };

    ref = React.createRef();

    componentDidMount() {
        metrika.send('Показ экрана ввода ФИ');
        this.ref.current.focus();
    }

    getTitleSize = () => {
        const {place} = this.props;

        if (place === MODE_BROWSER) {
            return 'l';
        }
    };

    getButtonSize = () => {
        const {place} = this.props;

        if (place === MODE_BROWSER) {
            return 'xm';
        }

        return 'l';
    };

    getFieldSize = () => {
        const {place} = this.props;

        if (place === MODE_BROWSER) {
            return 'm';
        }

        return 'l';
    };

    getViewType = () => {
        const {place} = this.props;

        if (place === MODE_BROWSER) {
            return 'one-border';
        }

        return 'big-input';
    };

    render() {
        const {fields, onConfirm} = this.props;

        return (
            <div className={b()}>
                <div className={b('head')}>
                    <Title size={this.getTitleSize()}>{i18n('_AUTH_.registration.step.personaldata.title')}</Title>
                </div>

                <div className={b('body')}>
                    {fields.map((name, index) => {
                        const Component = name === 'phone' ? Phone : Field;

                        return (
                            <Component
                                key={`reg-presonaldata-field-${index}`}
                                name={name}
                                ref={index === 0 ? this.ref : null}
                                shouldValidate={true}
                                size={this.getFieldSize()}
                                view={this.getViewType()}
                            />
                        );
                    })}
                </div>

                <div className={b('controls')}>
                    <Button
                        text={i18n('_AUTH_.next')}
                        onClick={onConfirm}
                        size={this.getButtonSize()}
                        width='max'
                        type='submit'
                    />
                </div>
            </div>
        );
    }
}

PersonalData.propTypes = {
    fields: PropTypes.arrayOf(PropTypes.string),
    onConfirm: PropTypes.func.isRequired,
    place: PropTypes.string
};

export {PersonalData};
