import './Password.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {Password} from '@components/Password';
import {Title} from '@components/Title';
import {Description} from '@components/Description';
import {Button} from '@components/Button';
import {FIELDS_NAMES} from '@components/Field/names';
import {classNames} from '@blocks/utils';
import metrika from '@blocks/metrics';

const b = classNames('PasswordSignUpBrowser');

class PasswordSignUpBrowser extends React.PureComponent {
    componentDidMount() {
        metrika.send('Показ экрана ввода пароля');
    }

    savePassword = () => {
        const {suggestedPassword, updateValues} = this.props;

        updateValues({field: FIELDS_NAMES.PASSWORD, value: suggestedPassword});
    };

    generatePassword = (event) => {
        const {generatePassword} = this.props;

        event.stopPropagation();
        generatePassword();
    };

    maybeRenderPasswordSuggest = () => {
        const {suggestedPassword} = this.props;

        if (!suggestedPassword) {
            return null;
        }

        return (
            <div className={b('suggest')} onClick={this.savePassword}>
                <button type='button' className={b('generate-button')} onClick={this.generatePassword} />
                <div className={b('suggested-password')}>{suggestedPassword}</div>
                {i18n('Frontend.registration.step.password.generate')}
            </div>
        );
    };

    render() {
        const {onConfirm} = this.props;

        return (
            <div className={b()}>
                <div className={b('head')}>
                    <Title size='l'>{i18n('_AUTH_.registration.step.password.title')}</Title>
                    <Description>{i18n('_AUTH_.registration.step.password.description')}</Description>
                </div>

                <div className={b('body')}>
                    <Password hideLabel={true} shouldValidate={true} size='l' />

                    {this.maybeRenderPasswordSuggest()}
                </div>

                <div className={b('controls')}>
                    <Button onClick={onConfirm} text={i18n('_AUTH_.next')} type='submit' size='xm' width='max' />
                </div>
            </div>
        );
    }
}

PasswordSignUpBrowser.propTypes = {
    onConfirm: PropTypes.func.isRequired,
    updateValues: PropTypes.func.isRequired,
    generatePassword: PropTypes.func,
    suggestedPassword: PropTypes.string
};

export {PasswordSignUpBrowser as Password};
