import {connect} from 'react-redux';
import {Password} from './Password.jsx';
import {generatePassword} from '@blocks/SignUp/modes/RegistrationWithSuggestToRestoreByPhone/logic';
import {updateValues} from '@blocks/actions/form';

const mapStateToProps = (state = {}) => {
    const {form = {}} = state;
    const {suggestedPassword} = form;

    return {suggestedPassword};
};

const mapDispatchToProps = {
    generatePassword,
    updateValues
};

const ConnectedPassword = connect(mapStateToProps, mapDispatchToProps)(Password);

export {ConnectedPassword as Password};
