import './Eula.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {Title} from '@components/Title';
import {Button} from '@components/Button';
import {Description} from '@components/Description';
import {classNames} from '@blocks/utils';
import metrika from '@blocks/metrics';
import {ServiceSubscriptionPermission} from '@components/ServiceSubscripionPermission';

const b = classNames('EulaSignUp');

const EULA_NAME = 'eula_accepted';

class EulaSignUp extends React.PureComponent {
    constructor(props) {
        super(props);

        this.state = {
            isEulaMoneyChecked: props.isEulaCheckedByDefault
        };
    }

    componentDidMount() {
        metrika.send('Показ экрана с пользовательским соглашением');
    }

    onClick = () => {
        const {onConfirm, updateValues} = this.props;

        updateValues({field: EULA_NAME, value: 'on'});
        onConfirm();
    };

    render() {
        const {eulaTexts, keepUnsubscribedExp, loading, buttonView} = this.props;
        const {title, description, button} = eulaTexts;

        return (
            <div className={b()}>
                <div className={b('head')}>
                    <Title>{title}</Title>
                    <Description>
                        <div
                            id='passp-eula-text'
                            dangerouslySetInnerHTML={{__html: description}}
                            className={b('eula', {leftAligned: keepUnsubscribedExp})}
                        />
                    </Description>
                    <ServiceSubscriptionPermission />
                </div>

                <div className={b('controls')}>
                    <Button
                        onClick={this.onClick}
                        text={button}
                        type='button'
                        view={buttonView}
                        width='max'
                        size='l'
                        disabled={loading}
                    />
                </div>
            </div>
        );
    }
}

EulaSignUp.propTypes = {
    updateValues: PropTypes.func.isRequired,
    onConfirm: PropTypes.func.isRequired,
    goBack: PropTypes.func,
    place: PropTypes.string,
    eulaTexts: PropTypes.shape({
        title: PropTypes.string,
        description: PropTypes.string,
        button: PropTypes.string
    }).isRequired,
    isEulaCheckedByDefault: PropTypes.bool,
    keepUnsubscribedExp: PropTypes.bool,
    loading: PropTypes.bool,
    buttonView: PropTypes.string,
    tmxSession: PropTypes.string.isRequired
};

export {EulaSignUp as Eula};
