import {Eula} from './Eula.jsx';
import {connect} from 'react-redux';
import {updateValues} from '@blocks/actions/form';
import {getEULATexts, hasExp} from '@blocks/selectors';

const mapStateToProps = (state = {}) => {
    const {form = {}, auth = {}, customs = {}} = state;
    const {isEulaCheckedByDefault} = form;
    const {loading} = auth;

    return {
        isEulaCheckedByDefault,
        keepUnsubscribedExp: hasExp(state, 'passport-subs-eula-check-on'),
        eulaTexts: getEULATexts(state),
        loading,
        buttonView: customs.buttonView
    };
};

const mapDispatchToProps = {
    updateValues
};

const ConnectedEula = connect(mapStateToProps, mapDispatchToProps)(Eula);

export {ConnectedEula as Eula};
